/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.contract.impl.HttpClientHttpResponse;
import com.ifengxue.http.executor.AbstractHttpExecutor;
import com.ifengxue.http.executor.ParameterUtil;
import com.ifengxue.http.executor.Request;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class FormDataHttpExecutor
extends AbstractHttpExecutor {
    @Override
    public HttpResponse execute(Request request, BodyType bodyType, ResponseType responseType) throws HttpClientException, IOException {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, Object> entry : request.getParameterMap().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof File) {
                entityBuilder.addBinaryBody(key, (File)value);
                continue;
            }
            if (value instanceof InputStream) {
                entityBuilder.addBinaryBody(key, (InputStream)value);
                continue;
            }
            if (value instanceof byte[]) {
                entityBuilder.addBinaryBody(key, (byte[])value);
                continue;
            }
            List<NameValuePair> nvps = ParameterUtil.createNameValueParis(key, value);
            for (NameValuePair nvp : nvps) {
                entityBuilder.addTextBody(key, nvp.getValue() == null ? "" : nvp.getValue(), ContentType.APPLICATION_FORM_URLENCODED.withCharset(this.charset));
            }
        }
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.getMethod()).setUri(request.getUrl()).setCharset(this.charset).setConfig(this.createConfig());
        requestBuilder.setEntity(entityBuilder.build());
        request.getHeaderMap().forEach((arg_0, arg_1) -> ((RequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
        return new HttpClientHttpResponse(this.httpClient.execute(requestBuilder.build()));
    }
}

