/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.executor.AbstractHttpExecutor;
import com.ifengxue.http.executor.FormDataHttpExecutor;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.JsonHttpExecutor;
import com.ifengxue.http.executor.UrlEncodedHttpExecutor;
import com.ifengxue.http.executor.XmlHttpExecutor;
import com.ifengxue.http.util.IOUtil;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpExecutorFactory {
    private static CloseableHttpClient httpClient;
    private static ExecutorService threadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpExecutor getHttpExecutor(BodyType bodyType) {
        if (httpClient != null) return this.getHttpExecutor(bodyType, httpClient);
        Class<HttpExecutorFactory> clazz = HttpExecutorFactory.class;
        synchronized (HttpExecutorFactory.class) {
            if (httpClient != null) return this.getHttpExecutor(bodyType, httpClient);
            httpClient = HttpClients.createDefault();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getHttpExecutor(bodyType, httpClient);
        }
    }

    public HttpExecutor getHttpExecutor(BodyType bodyType, CloseableHttpClient httpClient) {
        AbstractHttpExecutor executor;
        switch (bodyType) {
            case FORM_DATA: {
                executor = new FormDataHttpExecutor();
                break;
            }
            case APPLICATION_JSON: {
                executor = new JsonHttpExecutor();
                break;
            }
            case APPLICATION_XML: {
                executor = new XmlHttpExecutor();
                break;
            }
            case X_WWW_FORM_URLENCODED: {
                executor = new UrlEncodedHttpExecutor();
                break;
            }
            default: {
                throw new HttpClientException("\u6682\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b:" + (Object)((Object)bodyType));
            }
        }
        executor.setHttpClient(Objects.requireNonNull(httpClient));
        return executor;
    }

    public static ExecutorService getDefaultThreadPool() {
        return Optional.ofNullable(threadPool).orElseThrow(() -> new IllegalStateException("\u7ebf\u7a0b\u6c60\u4e0d\u5b58\u5728"));
    }

    public static ExecutorService setDefaultThreadPool(ExecutorService threadPool) {
        ExecutorService oldThreadPool = HttpExecutorFactory.threadPool;
        HttpExecutorFactory.threadPool = threadPool;
        return oldThreadPool;
    }

    @Deprecated
    public CloseableHttpClient getHttpClient() {
        return Optional.ofNullable(httpClient).orElseThrow(() -> new IllegalStateException("httpClient\u5df2\u7ecf\u88ab\u5173\u95ed\uff01"));
    }

    @Deprecated
    public synchronized void setHttpClient(CloseableHttpClient httpClient) {
        Objects.requireNonNull(httpClient);
        HttpExecutorFactory.close();
        HttpExecutorFactory.httpClient = httpClient;
    }

    public static void close() {
        try {
            IOUtil.closeQuietly(new Closeable[]{httpClient});
        }
        finally {
            httpClient = null;
        }
    }

    public synchronized void setDefaultHttpClient(CloseableHttpClient httpClient) {
        Objects.requireNonNull(httpClient);
        HttpExecutorFactory.close();
        HttpExecutorFactory.httpClient = httpClient;
    }

    public CloseableHttpClient getDefaultHttClient() {
        return Objects.requireNonNull(httpClient, "\u6ca1\u6709\u9ed8\u8ba4\u7684http client");
    }

    static {
        threadPool = ForkJoinPool.commonPool();
    }
}

