/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.annotation.Header;
import com.ifengxue.http.annotation.HttpMethod;
import com.ifengxue.http.collection.MultiMap;
import com.ifengxue.http.contract.CallbackHandler;
import com.ifengxue.http.executor.ParameterUtil;
import com.ifengxue.http.executor.RequestContext;
import io.mikael.urlbuilder.UrlBuilder;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class Request
implements RequestContext {
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{(.*?)}");
    private String url;
    private String method;
    private Set<String> queryParameterNames;
    private Map<String, Object> parameterMap;
    private Object body;
    private Map<String, String> headerMap;
    private CallbackHandler callbackHandler;
    private RequestContext requestContext = new RequestContext.SimpleRequestContext();

    private Request() {
    }

    public Request replaceUrl(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public Request addHeader(String name, String value) {
        Objects.requireNonNull(this.headerMap).put(name, value);
        return this;
    }

    public Request removeHeader(String name) {
        Objects.requireNonNull(this.headerMap).remove(name);
        return this;
    }

    public boolean containsHeader(String name) {
        return Optional.ofNullable(this.headerMap).map(m -> m.containsKey(name)).orElse(false);
    }

    public Request addParameter(String name, Object value) {
        Map<String, Object> map = Objects.requireNonNull(this.parameterMap);
        if (!map.containsKey(name)) {
            map.put(name, value);
        } else {
            Object value0 = map.get(name);
            if (value0 instanceof Collection) {
                if (value instanceof Collection) {
                    ((Collection)value0).addAll((Collection)value);
                } else {
                    ((Collection)value0).add(value);
                }
            } else {
                LinkedList<Object> paramArray = new LinkedList<Object>();
                paramArray.add(value0);
                if (value instanceof Collection) {
                    paramArray.addAll((Collection)value);
                } else {
                    paramArray.add(value);
                }
                map.put(name, paramArray);
            }
        }
        return this;
    }

    public Request removeParameter(String name) {
        Objects.requireNonNull(this.parameterMap).remove(name);
        return this;
    }

    public <T> T getBody() {
        return (T)this.body;
    }

    public String toString() {
        return "Request(url=" + this.getUrl() + ", method=" + this.getMethod() + ", queryParameterNames=" + this.getQueryParameterNames() + ", parameterMap=" + this.getParameterMap() + ", body=" + this.getBody() + ", headerMap=" + this.getHeaderMap() + ", callbackHandler=" + this.getCallbackHandler() + ", requestContext=" + this.requestContext + ")";
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Set<String> getQueryParameterNames() {
        return this.queryParameterNames;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public <T> RequestContext setAttribute(String name, T value) {
        return this.requestContext.setAttribute(name, value);
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.requestContext.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, T defValue) {
        return this.requestContext.getAttribute(name, defValue);
    }

    @Override
    public <T> T removeAttribute(String name) {
        return this.requestContext.removeAttribute(name);
    }

    @Override
    public void clearAllAttribute() {
        this.requestContext.clearAllAttribute();
    }

    public static class Builder {
        private final Request request = new Request();
        private URL prefixUrl;
        private String suffixUrl;

        private Builder() {
            this.request.parameterMap = new HashMap();
            this.request.headerMap = new HashMap();
            this.request.queryParameterNames = new HashSet();
        }

        public static Builder newBuilder(String method) {
            Builder builder = new Builder();
            builder.request.method = method;
            return builder;
        }

        public static Builder newGetBuilder() {
            return Builder.newBuilder(HttpMethod.GET.name());
        }

        public static Builder newPostBuilder() {
            return Builder.newBuilder(HttpMethod.POST.name());
        }

        public static Builder newPutBuilder() {
            return Builder.newBuilder(HttpMethod.PUT.name());
        }

        public static Builder newPatchBuilder() {
            return Builder.newBuilder(HttpMethod.PATCH.name());
        }

        public static Builder newDeleteBuilder() {
            return Builder.newBuilder(HttpMethod.DELETE.name());
        }

        public static Builder newHeadBuilder() {
            return Builder.newBuilder(HttpMethod.HEAD.name());
        }

        public Builder setPrefixUrl(URL prefixUrl) {
            this.prefixUrl = prefixUrl;
            return this;
        }

        public Builder setSuffixUrl(String suffixUrl) {
            this.suffixUrl = suffixUrl;
            return this;
        }

        public Builder addParameter(String name, Object value) {
            this.request.addParameter(name, value);
            return this;
        }

        public Builder addParameters(MultiMap<String> multiMap) {
            multiMap.forEach(this.request::addParameter);
            return this;
        }

        public <T> Builder setBody(T body) {
            this.request.body = body;
            return this;
        }

        public Builder addQueryParameterNames(Set<String> queryParameterNames) {
            this.request.queryParameterNames.addAll(queryParameterNames);
            return this;
        }

        public Builder addQueryParameterNames(String ... queryParameterNames) {
            this.request.queryParameterNames.addAll(Arrays.asList(queryParameterNames));
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.request.addHeader(name, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headerMap) {
            headerMap.forEach(this.request::addHeader);
            return this;
        }

        public Builder addHeaders(Header[] headers) {
            for (Header header : headers) {
                this.request.addHeader(header.name(), header.value());
            }
            return this;
        }

        public Builder setCallbackHandler(CallbackHandler callbackHandler) {
            this.request.callbackHandler = callbackHandler;
            return this;
        }

        public Request build() {
            if (StringUtils.isBlank((CharSequence)this.request.method)) {
                throw new IllegalArgumentException("must set the http request method");
            }
            String targetUrl = Optional.ofNullable(this.prefixUrl).map(URL::toString).orElse("");
            if (StringUtils.isNotBlank((CharSequence)this.suffixUrl)) {
                if (StringUtils.isNotBlank((CharSequence)targetUrl) && targetUrl.endsWith("/")) {
                    targetUrl = targetUrl.substring(0, targetUrl.length() - 1);
                }
                targetUrl = StringUtils.isBlank((CharSequence)targetUrl) ? this.suffixUrl : (this.suffixUrl.startsWith("/") ? targetUrl + this.suffixUrl : targetUrl + "/" + this.suffixUrl);
            }
            if (StringUtils.isBlank((CharSequence)targetUrl)) {
                throw new IllegalStateException(String.format("Invalid prefix url %s or suffix url %s", this.prefixUrl, this.suffixUrl));
            }
            Matcher matcher = PATH_VARIABLE_PATTERN.matcher(targetUrl);
            HashSet<String> pathVariableNames = new HashSet<String>();
            while (matcher.find()) {
                String pathVariableName = matcher.group(1);
                String value = Optional.ofNullable(this.request.parameterMap.get(pathVariableName)).map(Object::toString).orElseThrow(() -> new IllegalStateException("cannot find a value matching '" + pathVariableName + "'"));
                targetUrl = targetUrl.replace("{" + pathVariableName + "}", value);
                pathVariableNames.add(pathVariableName);
            }
            pathVariableNames.forEach(k -> this.request.parameterMap.remove(k));
            if (!this.request.getQueryParameterNames().isEmpty()) {
                UrlBuilder urlBuilder = UrlBuilder.fromString((String)targetUrl, (Charset)StandardCharsets.UTF_8);
                for (String queryParameterName : this.request.getQueryParameterNames()) {
                    Object value = this.request.getParameterMap().getOrDefault(queryParameterName, "");
                    for (NameValuePair nameValuePair : ParameterUtil.createNameValueParis(queryParameterName, value)) {
                        urlBuilder = urlBuilder.addParameter(nameValuePair.getName(), StringUtils.trimToEmpty((String)nameValuePair.getValue()));
                    }
                    this.request.getParameterMap().remove(queryParameterName);
                }
                targetUrl = urlBuilder.toUrl().toString();
            }
            this.request.url = targetUrl;
            return this.request;
        }
    }
}

