/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface RequestContext {
    public <T> RequestContext setAttribute(String var1, T var2);

    public <T> T getAttribute(String var1);

    public <T> T getAttribute(String var1, T var2);

    public <T> T removeAttribute(String var1);

    public void clearAllAttribute();

    public static class SimpleRequestContext
    implements RequestContext {
        private Map<String, Object> contextMap = Collections.emptyMap();

        @Override
        public <T> RequestContext setAttribute(String name, T value) {
            this.getContextMapInternal().put(name, value);
            return this;
        }

        @Override
        public <T> T getAttribute(String name) {
            return (T)this.contextMap.get(name);
        }

        @Override
        public <T> T getAttribute(String name, T defValue) {
            return (T)this.contextMap.getOrDefault(name, defValue);
        }

        @Override
        public <T> T removeAttribute(String name) {
            return (T)this.getContextMapInternal().remove(name);
        }

        @Override
        public void clearAllAttribute() {
            this.getContextMapInternal().clear();
        }

        private Map<String, Object> getContextMapInternal() {
            Map emptyMap = Collections.emptyMap();
            if (this.contextMap == emptyMap) {
                this.contextMap = new HashMap<String, Object>();
                return this.contextMap;
            }
            return this.contextMap;
        }
    }
}

