/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.contract.impl.HttpClientHttpResponse;
import com.ifengxue.http.executor.AbstractHttpExecutor;
import com.ifengxue.http.executor.ParameterUtil;
import com.ifengxue.http.executor.Request;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;

public class UrlEncodedHttpExecutor
extends AbstractHttpExecutor {
    @Override
    public HttpResponse execute(Request request, BodyType bodyType, ResponseType responseType) throws HttpClientException, IOException {
        if (request.getBody() != null) {
            throw new HttpClientException("Body type " + bodyType.name() + " not support request body.");
        }
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod()).setUri(request.getUrl()).setCharset(this.charset).setConfig(this.createConfig());
        request.getHeaderMap().forEach((arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
        for (Map.Entry<String, Object> entry : request.getParameterMap().entrySet()) {
            List<NameValuePair> nvps = ParameterUtil.createNameValueParis(entry.getKey(), entry.getValue());
            nvps.forEach(arg_0 -> ((RequestBuilder)builder).addParameter(arg_0));
        }
        if (!request.containsHeader("Content-Type")) {
            builder.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.withCharset(this.getCharset()).toString());
        }
        return new HttpClientHttpResponse(this.httpClient.execute(builder.build()));
    }
}

