/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.codec.CodecFactory;
import com.ifengxue.http.codec.XmlCodec;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.contract.impl.HttpClientHttpResponse;
import com.ifengxue.http.executor.AbstractHttpExecutor;
import com.ifengxue.http.executor.Request;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class XmlHttpExecutor
extends AbstractHttpExecutor {
    @Override
    public HttpResponse execute(Request request, BodyType bodyType, ResponseType responseType) throws HttpClientException, IOException {
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod()).setUri(request.getUrl()).setCharset(this.charset).setConfig(this.createConfig());
        request.getHeaderMap().forEach((arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
        if (request.getBody() != null) {
            XmlCodec codec = CodecFactory.findCodec(XmlCodec.class);
            builder.setEntity((HttpEntity)new StringEntity(codec.encode(request.getBody()), ContentType.APPLICATION_XML.withCharset(this.charset)));
        }
        if (!request.containsHeader("Content-Type")) {
            builder.addHeader("Content-Type", ContentType.APPLICATION_XML.withCharset(this.getCharset()).toString());
        }
        return new HttpClientHttpResponse(this.httpClient.execute(builder.build()));
    }
}

