/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.parser;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.codec.Codec;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.parser.HttpParser;
import com.ifengxue.http.util.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class CodecHttpParser
implements HttpParser {
    protected final Codec codec;

    public CodecHttpParser(Codec codec) {
        this.codec = codec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parse(HttpResponse response, Charset charset, Type type) throws HttpClientException, IOException {
        try {
            if (TypeUtil.isVoidType(type)) {
                T t = null;
                return t;
            }
            String string = response.getContent(charset);
            if (StringUtils.isBlank((CharSequence)string)) {
                T t = null;
                return t;
            }
            if (TypeUtil.isTypeOf(type, String.class)) {
                String string2 = string;
                return (T)string2;
            }
            if (TypeUtil.isTypeOf(type, BigDecimal.class)) {
                BigDecimal bigDecimal = new BigDecimal(string);
                return (T)bigDecimal;
            }
            if (TypeUtil.isTypeOf(type, BigInteger.class)) {
                BigInteger bigInteger = new BigInteger(string);
                return (T)bigInteger;
            }
            if (TypeUtil.isPrimitiveType(type)) {
                Object t = TypeUtil.resolvePrimitiveTypeValue(string, TypeUtil.findActualType(type));
                return t;
            }
            Object t = this.codec.decode(string, TypeUtil.findActualType(type));
            return t;
        }
        catch (HttpClientException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientException(e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
    }
}

