/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.parser;

import com.ifengxue.http.contract.HttpResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class FilenameInputStream
implements AutoCloseable,
Closeable {
    private final String filename;
    private final InputStream stream;

    public static FilenameInputStream from(HttpResponse response) throws IOException {
        String headerValue = response.getHeaderValue("Content-Disposition");
        String filename = FilenameInputStream.parseAttachmentFilename(headerValue);
        return new FilenameInputStream(filename, response.getContent());
    }

    public FilenameInputStream(String filename, InputStream stream) {
        this.filename = filename;
        this.stream = stream;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return "FilenameInputStream{filename='" + this.filename + '\'' + ", stream=" + this.stream + '}';
    }

    static String parseAttachmentFilename(String headerValue) throws UnsupportedEncodingException {
        if (headerValue == null) {
            return null;
        }
        String filenameWild = "filename*";
        int filenameWildIndex = headerValue.indexOf(filenameWild);
        if (filenameWildIndex != -1) {
            int lastIndex = headerValue.indexOf(59, filenameWildIndex);
            String substring = lastIndex == -1 ? headerValue.substring(filenameWildIndex + filenameWild.length() + 1) : headerValue.substring(filenameWildIndex + filenameWild.length() + 1, lastIndex);
            String[] ary = substring.split("''");
            return URLDecoder.decode(ary[1], ary[0]);
        }
        String filename = "filename";
        int filenameIndex = headerValue.indexOf(filename);
        if (filenameIndex != -1) {
            int lastIndex = headerValue.indexOf(59, filenameIndex);
            int offset = 2;
            if (headerValue.substring(filenameIndex + filename.length() + 1).charAt(0) != '\"') {
                offset = 1;
            }
            String substring = lastIndex == -1 ? headerValue.substring(filenameIndex + filename.length() + offset) : headerValue.substring(filenameIndex + filename.length() + offset, offset == 2 ? lastIndex - 1 : lastIndex);
            return URLDecoder.decode(substring, "UTF-8");
        }
        throw new IllegalStateException("Not valid Content-Disposition header: " + headerValue);
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

