/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.parser;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.contract.Header;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.parser.HttpParser;
import com.ifengxue.http.parser.UnsupportedTypeException;
import com.ifengxue.http.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class HeaderHttpParser
implements HttpParser {
    @Override
    public <T> T parse(HttpResponse response, Charset charset, Type type) throws HttpClientException {
        if (TypeUtil.isVoidType(type)) {
            throw new UnsupportedTypeException("void is unsupported type");
        }
        Type actualType = TypeUtil.findActualType(type);
        if (actualType == Header[].class) {
            return (T)response.getAllHeaders();
        }
        if (actualType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualType;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new UnsupportedTypeException(type.getTypeName() + " is unsupported type");
            }
            Class rawClass = (Class)rawType;
            if (Collection.class.isAssignableFrom(rawClass)) {
                if (parameterizedType.getActualTypeArguments()[0] != Header.class) {
                    throw new UnsupportedTypeException(parameterizedType.getActualTypeArguments()[0].getTypeName() + " is unsupported type");
                }
                return (T)Arrays.stream(response.getAllHeaders()).collect(Collectors.toList());
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                    if (actualTypeArgument == String.class) continue;
                    throw new UnsupportedTypeException(actualTypeArgument.getTypeName() + " is unsupported type");
                }
                return (T)Arrays.stream(response.getAllHeaders()).collect(Collectors.toMap(Header::getName, Header::getValue));
            }
            throw new UnsupportedTypeException(rawType.getTypeName() + " is unsupported type");
        }
        throw new UnsupportedTypeException(actualType.getTypeName() + " is unsupported type");
    }
}

