/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.parser;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.codec.CodecFactory;
import com.ifengxue.http.codec.JsonCodec;
import com.ifengxue.http.codec.XmlCodec;
import com.ifengxue.http.parser.CodecHttpParser;
import com.ifengxue.http.parser.HeaderHttpParser;
import com.ifengxue.http.parser.HttpParser;
import com.ifengxue.http.parser.StreamHttpParser;
import com.ifengxue.http.parser.StringHttpParser;

public final class HttpParserFactory {
    public HttpParser getHttpParser(ResponseType responseType) {
        HttpParser httpParser;
        switch (responseType) {
            case TEXT: {
                httpParser = new StringHttpParser();
                break;
            }
            case APPLICATION_JSON: {
                httpParser = new CodecHttpParser(CodecFactory.findCodec(JsonCodec.class));
                break;
            }
            case APPLICATION_XML: {
                httpParser = new CodecHttpParser(CodecFactory.findCodec(XmlCodec.class));
                break;
            }
            case STREAM: {
                httpParser = new StreamHttpParser();
                break;
            }
            case HEADER: {
                httpParser = new HeaderHttpParser();
                break;
            }
            default: {
                throw new HttpClientException("Not support response type:" + (Object)((Object)responseType));
            }
        }
        return httpParser;
    }
}

