/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.proxy;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.proxy.InterceptorAdaptor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthInterceptor
extends InterceptorAdaptor {
    private final String username;
    private final String password;
    private final Charset charset;

    public BasicAuthInterceptor(String username, String password) {
        this(username, password, StandardCharsets.UTF_8);
    }

    public BasicAuthInterceptor(@NonNull String username, String password, Charset charset) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    @Override
    public <T> T beforeRequest(Method method, Request request, BodyType bodyType, ResponseType responseType, HttpExecutor executor) throws HttpClientException {
        String base64 = Base64.encodeBase64String((byte[])(this.username + ":" + Optional.ofNullable(this.password).orElse("")).getBytes(this.charset));
        request.addHeader("Authorization", "Basic " + base64);
        return null;
    }
}

