/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.proxy;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.parser.HttpParser;
import com.ifengxue.http.proxy.Interceptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);
    private static final String EXECUTE_BEGIN_TIME = "__execute_begin_time";
    private String lineSeparator = System.getProperty("line.separator");

    @Override
    public <T> T beforeRequest(Method method, Request request, BodyType bodyType, ResponseType responseType, HttpExecutor executor) throws HttpClientException {
        request.setAttribute(EXECUTE_BEGIN_TIME, System.currentTimeMillis());
        StringBuilder builder = new StringBuilder(1024);
        builder.append(this.lineSeparator).append("=========================Before Request Start=========================").append(this.lineSeparator);
        builder.append("MethodName: ").append(method.getName()).append(this.lineSeparator);
        builder.append("HttpExecutor: ").append(executor.getClass().getName()).append(this.lineSeparator);
        builder.append(request.getMethod()).append(" ").append(request.getUrl()).append(this.lineSeparator);
        builder.append("BodyType: ").append((Object)bodyType).append(this.lineSeparator);
        builder.append("ResponseType: ").append((Object)responseType).append(this.lineSeparator);
        request.getHeaderMap().forEach((name, value) -> builder.append((String)name).append(": ").append((String)value).append(this.lineSeparator));
        request.getParameterMap().forEach((name, value) -> builder.append((String)name).append("=").append(value).append(this.lineSeparator));
        builder.append("=========================Before Request End=========================");
        log.info(builder.toString());
        return null;
    }

    @Override
    public <T> T beforeParse(Method method, Request request, BodyType bodyType, ResponseType responseType, HttpResponse httpResponse, HttpParser httpParser) throws HttpClientException, IOException {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(this.lineSeparator).append("=========================Before Parse Start=========================").append(this.lineSeparator);
        builder.append("MethodName: ").append(method.getName()).append(this.lineSeparator);
        builder.append("HttpParser: ").append(httpParser.getClass().getName()).append(this.lineSeparator);
        builder.append(request.getMethod()).append(" ").append(request.getUrl()).append(this.lineSeparator);
        builder.append("Status Code: ").append(httpResponse.getStatusCode()).append(this.lineSeparator);
        Arrays.stream(httpResponse.getAllHeaders()).forEach(header -> builder.append(header.getName()).append(": ").append(header.getValue()).append(this.lineSeparator));
        long executeBeginTime = (Long)request.getAttribute(EXECUTE_BEGIN_TIME);
        long executeEndTime = System.currentTimeMillis();
        builder.append("Execute time: ").append(executeEndTime - executeBeginTime).append(" ms").append(this.lineSeparator);
        builder.append("=========================Before Parse End=========================");
        log.info(builder.toString());
        return null;
    }
}

