/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.proxy;

import com.ifengxue.http.proxy.HttpClientConfig;
import com.ifengxue.http.proxy.Interceptor;
import com.ifengxue.http.proxy.RequestInvoker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.CloseableHttpClient;

public class ProxyBuilder {
    private static final int UNSET_INT_VALUE = -1;
    private ClassLoader classLoader;
    private Class<?> proxyInterface;
    private List<Interceptor> interceptors = new LinkedList<Interceptor>();
    private Charset charset = StandardCharsets.UTF_8;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String userAgent;
    private String host;
    private String proxyScheme;
    private String proxyHost;
    private int proxyPort;
    private int socketTimeout = -1;
    private int connectTimeout = -1;
    private CloseableHttpClient httpClient;
    private ExecutorService threadPool;
    private UsernamePasswordCredentials basicAuthCredentials;

    public static ProxyBuilder newBuilder() {
        return new ProxyBuilder();
    }

    private ProxyBuilder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
    }

    public ProxyBuilder classLoader(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        this.classLoader = classLoader;
        return this;
    }

    public ProxyBuilder proxyInterface(@NonNull Class<?> proxyInterface) {
        if (proxyInterface == null) {
            throw new NullPointerException("proxyInterface");
        }
        this.proxyInterface = proxyInterface;
        return this;
    }

    public ProxyBuilder addInterceptor(@NonNull Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor");
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public ProxyBuilder addInterceptors(@NonNull List<Interceptor> interceptors) {
        if (interceptors == null) {
            throw new NullPointerException("interceptors");
        }
        this.interceptors.addAll(interceptors);
        return this;
    }

    public ProxyBuilder charset(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
        return this;
    }

    public ProxyBuilder addHeader(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.headers.put(name, value);
        return this;
    }

    public ProxyBuilder addHeaders(@NonNull Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.headers.putAll(headers);
        return this;
    }

    public ProxyBuilder addParameter(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.parameters.put(name, value);
        return this;
    }

    public ProxyBuilder addParameters(@NonNull Map<String, Object> parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this.parameters.putAll(parameters);
        return this;
    }

    public ProxyBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ProxyBuilder host(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.host = host;
        return this;
    }

    public ProxyBuilder proxyScheme(@NonNull String proxyScheme) {
        if (proxyScheme == null) {
            throw new NullPointerException("proxyScheme");
        }
        this.proxyScheme = proxyScheme;
        return this;
    }

    public ProxyBuilder proxyHost(@NonNull String proxyHost) {
        if (proxyHost == null) {
            throw new NullPointerException("proxyHost");
        }
        this.proxyHost = proxyHost;
        return this;
    }

    public ProxyBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public ProxyBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ProxyBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ProxyBuilder httpClient(@NonNull CloseableHttpClient httpClient) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        this.httpClient = httpClient;
        return this;
    }

    public ProxyBuilder threadPool(@NonNull ExecutorService threadPool) {
        if (threadPool == null) {
            throw new NullPointerException("threadPool");
        }
        this.threadPool = threadPool;
        return this;
    }

    public ProxyBuilder basicAuth(@NonNull String username, String password) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        this.basicAuthCredentials = new UsernamePasswordCredentials(username, password);
        return this;
    }

    public <T> T build() {
        Object proxyObject = RequestInvoker.create(this.proxyInterface, this.classLoader);
        HttpClientConfig httpClientConfig = (HttpClientConfig)proxyObject;
        this.interceptors.forEach(httpClientConfig::addInterceptor);
        Optional.ofNullable(this.charset).ifPresent(httpClientConfig::setCharset);
        this.headers.forEach(httpClientConfig::addHeader);
        this.parameters.forEach(httpClientConfig::addParameter);
        Optional.ofNullable(this.userAgent).ifPresent(httpClientConfig::setUserAgent);
        Optional.ofNullable(this.host).ifPresent(httpClientConfig::setHost);
        Optional.ofNullable(this.proxyHost).ifPresent(ph -> httpClientConfig.setProxy(this.proxyHost, this.proxyPort, this.proxyScheme));
        if (-1 != this.socketTimeout || -1 != this.connectTimeout) {
            httpClientConfig.setTimeout(this.socketTimeout, this.connectTimeout);
        }
        if (this.httpClient != null) {
            httpClientConfig.setHttpClient(this.httpClient);
        }
        if (this.threadPool != null) {
            httpClientConfig.setThreadPool(this.threadPool);
        }
        if (this.basicAuthCredentials != null) {
            httpClientConfig.setBasicAuth(this.basicAuthCredentials.getUserName(), this.basicAuthCredentials.getPassword());
        }
        return (T)proxyObject;
    }
}

