/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.proxy;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.Delete;
import com.ifengxue.http.annotation.Get;
import com.ifengxue.http.annotation.Head;
import com.ifengxue.http.annotation.HttpMethod;
import com.ifengxue.http.annotation.Patch;
import com.ifengxue.http.annotation.Post;
import com.ifengxue.http.annotation.Put;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.annotation.Rest;
import com.ifengxue.http.collection.MultiMap;
import com.ifengxue.http.collection.MultiValueMap;
import com.ifengxue.http.contract.Callback;
import com.ifengxue.http.contract.HttpOperations;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.HttpExecutorFactory;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.parser.HttpParser;
import com.ifengxue.http.parser.HttpParserFactory;
import com.ifengxue.http.parser.StreamHttpParser;
import com.ifengxue.http.proxy.BasicAuthInterceptor;
import com.ifengxue.http.proxy.HttpClientConfig;
import com.ifengxue.http.proxy.Interceptor;
import com.ifengxue.http.proxy.Resolver;
import com.ifengxue.http.util.IOUtil;
import com.ifengxue.http.util.TypeUtil;
import com.ifengxue.http.util.Version;
import io.mikael.urlbuilder.UrlBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.CloseableHttpClient;

public class RequestInvoker
implements InvocationHandler,
HttpClientConfig,
HttpOperations {
    private static final Timeout NOT_SET_TIMEOUT = new Timeout();
    private final Class<?> proxyInterface;
    private final HttpExecutorFactory executorFactory = new HttpExecutorFactory();
    private final HttpParserFactory parserFactory = new HttpParserFactory();
    private final LinkedList<Interceptor> interceptors = new LinkedList();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final MultiMap<String> parameters = new MultiValueMap<String>();
    private final Map<Method, Method> httpOperationsDelegateMethod = new ConcurrentHashMap<Method, Method>();
    private final Rest rest;
    private volatile URL prefixUrl;
    private Charset charset = UTF_8;
    private HttpHost proxy;
    private Timeout timeout = NOT_SET_TIMEOUT;
    private volatile UsernamePasswordCredentials basicAuthCredentials;
    private AtomicBoolean basicAuthInterceptorHasSet = new AtomicBoolean(false);
    private CloseableHttpClient customHttpClient;
    private ExecutorService threadPool;

    private RequestInvoker(Class<?> proxyInterface) {
        this.proxyInterface = proxyInterface;
        this.rest = proxyInterface.getAnnotation(Rest.class);
        this.setUserAgent("Http-client-proxy/" + Version.getVersion() + " Java/" + SystemUtils.JAVA_VERSION);
    }

    public static <T> T create(Class<T> proxyInterface) {
        return RequestInvoker.create(proxyInterface, Thread.currentThread().getContextClassLoader());
    }

    public static <T> T create(Class<T> proxyInterface, ClassLoader classLoader) {
        Objects.requireNonNull(proxyInterface, "proxyInterface cannot be null");
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException(proxyInterface.getName() + " not an interface");
        }
        classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        classLoader = classLoader == null ? RequestInvoker.class.getClassLoader() : classLoader;
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface, HttpClientConfig.class, HttpOperations.class}, (InvocationHandler)new RequestInvoker(proxyInterface));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString") && args == null) {
            return this.proxyInterface.getSimpleName() + " is proxy by " + this.getClass().getSimpleName() + "!";
        }
        if (method.getName().equals("hashCode") && args == null) {
            return Objects.hashCode(this);
        }
        if (method.getName().equals("equals") && args != null && args.length == 1) {
            return Objects.equals(this, args[0]);
        }
        if (method.getDeclaringClass() == HttpClientConfig.class) {
            return method.invoke((Object)this, args);
        }
        if (method.isDefault()) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(method.getDeclaringClass())).in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }
        this.doInit();
        if (method.getDeclaringClass() == HttpOperations.class) {
            return this.findHttpOperationsDelegateMethod(method).invoke((Object)this, this.createNewArgs(method, args));
        }
        RequestMethodHolder requestMethodHolder = this.createHolder(method);
        MultiMap<String> parameterMap = Resolver.resolveParameters(method, args, requestMethodHolder.getBodyType());
        Request request = Request.Builder.newBuilder(requestMethodHolder.getMethod()).setPrefixUrl(this.prefixUrl).setSuffixUrl(requestMethodHolder.getSuffixUrl()).addHeaders(this.headers).addHeaders(Resolver.resolveHeaders(method)).addHeaders(Resolver.resolveParamHeaders(method, args)).addParameters(this.parameters).addParameters(parameterMap).setBody(Resolver.resolveBody(method, args)).addQueryParameterNames(Resolver.resolveQueryParameterNames(method, args)).setCallbackHandler(Resolver.findCallbackHandler(method, args)).build();
        if (request.getCallbackHandler() == null) {
            HttpInvokerSupplier supplier = new HttpInvokerSupplier(method, request, requestMethodHolder);
            if (TypeUtil.isAsyncType(method.getReturnType())) {
                return CompletableFuture.supplyAsync(supplier, this.getThreadPool());
            }
            return supplier.get();
        }
        Callback<?> callback = request.getCallbackHandler().getCallback();
        HttpInvokerSupplier supplier = new HttpInvokerSupplier(method, request, requestMethodHolder.getBodyType(), requestMethodHolder.getResponseType(), request.getCallbackHandler().getResponseType());
        CompletableFuture.supplyAsync(supplier, this.getThreadPool()).whenCompleteAsync(callback::call, (Executor)this.getThreadPool());
        return null;
    }

    private Object[] createNewArgs(Method method, Object[] args) {
        Object[] newArgs = new Object[method.getParameterTypes().length + 1];
        if (newArgs.length > 1) {
            System.arraycopy(args, 0, newArgs, 1, args.length);
        }
        newArgs[0] = method;
        return newArgs;
    }

    private Method findHttpOperationsDelegateMethod(Method method) {
        return this.httpOperationsDelegateMethod.computeIfAbsent(method, m -> {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class[] newParameterTypes = new Class[parameterTypes.length + 1];
            if (parameterTypes.length > 0) {
                System.arraycopy(parameterTypes, 0, newParameterTypes, 1, parameterTypes.length);
            }
            newParameterTypes[0] = Method.class;
            try {
                Method delegateMethod = RequestInvoker.class.getDeclaredMethod(method.getName(), newParameterTypes);
                delegateMethod.setAccessible(true);
                return delegateMethod;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find matched delegate method " + method.getName());
            }
        });
    }

    private HttpExecutor createHttpExecutor(BodyType bodyType) {
        HttpExecutor executor = this.customHttpClient == null ? this.executorFactory.getHttpExecutor(bodyType) : this.executorFactory.getHttpExecutor(bodyType, this.customHttpClient);
        executor.setCharset(this.charset);
        executor.setProxy(this.proxy);
        executor.setTimeout(this.timeout.socketTimeout, this.timeout.connectTimeout);
        return executor;
    }

    private RequestMethodHolder createHolder(Method method) {
        if (method.isAnnotationPresent(Get.class)) {
            Get get = method.getAnnotation(Get.class);
            return new RequestMethodHolder(HttpMethod.GET.name(), get.value(), get.bodyType(), get.responseType());
        }
        if (method.isAnnotationPresent(Post.class)) {
            Post post = method.getAnnotation(Post.class);
            return new RequestMethodHolder(HttpMethod.POST.name(), post.value(), post.bodyType(), post.responseType());
        }
        if (method.isAnnotationPresent(Put.class)) {
            Put put = method.getAnnotation(Put.class);
            return new RequestMethodHolder(HttpMethod.PUT.name(), put.value(), put.bodyType(), put.responseType());
        }
        if (method.isAnnotationPresent(Patch.class)) {
            Patch patch = method.getAnnotation(Patch.class);
            return new RequestMethodHolder(HttpMethod.PATCH.name(), patch.value(), patch.bodyType(), patch.responseType());
        }
        if (method.isAnnotationPresent(Delete.class)) {
            Delete delete = method.getAnnotation(Delete.class);
            return new RequestMethodHolder(HttpMethod.DELETE.name(), delete.value(), delete.bodyType(), delete.responseType());
        }
        if (method.isAnnotationPresent(Head.class)) {
            Head head = method.getAnnotation(Head.class);
            return new RequestMethodHolder(HttpMethod.DELETE.name(), head.value(), head.bodyType(), ResponseType.HEADER);
        }
        throw new IllegalStateException("method does not specify a matching annotation " + Arrays.toString(new String[]{Get.class.getName(), Post.class.getName(), Put.class.getName(), Patch.class.getName(), Delete.class.getName(), Head.class.getName()}));
    }

    private void initPrefixUrl(String host) {
        if (StringUtils.isBlank((CharSequence)host) && (this.rest == null || StringUtils.isBlank((CharSequence)this.rest.value()))) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)host)) {
            this.prefixUrl = this.decodeURL(UrlBuilder.fromString((String)this.rest.value()).toUrl());
            return;
        }
        if (this.rest == null || this.rest.value().isEmpty()) {
            this.prefixUrl = this.decodeURL(UrlBuilder.fromString((String)host).toUrl());
            return;
        }
        UrlBuilder rawHost = UrlBuilder.fromString((String)this.rest.value());
        URL replaceHost = this.decodeURL(UrlBuilder.fromString((String)host).toUrl());
        this.prefixUrl = this.decodeURL(rawHost.withScheme(replaceHost.getProtocol()).withHost(replaceHost.getHost()).withPort(replaceHost.getPort() == -1 ? null : Integer.valueOf(replaceHost.getPort())).withUserInfo(replaceHost.getUserInfo()).withPath(replaceHost.getPath()).withQuery(replaceHost.getQuery()).toUrl());
    }

    private URL decodeURL(URL url) {
        try {
            return new URL(URLDecoder.decode(url.toString(), StandardCharsets.UTF_8.name()));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url:" + url.toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("invalid charset", e);
        }
    }

    @Override
    public synchronized void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public synchronized void removeInterceptors(Interceptor interceptor) throws NoSuchElementException {
        if (!this.interceptors.removeIf(other -> other == interceptor)) {
            throw new NoSuchElementException("No matching interceptors, interceptor instance is " + interceptor);
        }
    }

    @Override
    public synchronized void removeInterceptors(Class<? extends Interceptor> interceptorClass) throws NoSuchElementException {
        if (!this.interceptors.removeIf(interceptor -> interceptor.getClass() == interceptorClass)) {
            throw new NoSuchElementException("No matching interceptors, interceptor type is " + interceptorClass.getName());
        }
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public synchronized void setUserAgent(String userAgent) {
        this.addHeader("User-Agent", userAgent);
    }

    @Override
    public synchronized void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public synchronized void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHost(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalArgumentException("host can't be empty value");
        }
        RequestInvoker requestInvoker = this;
        synchronized (requestInvoker) {
            this.prefixUrl = null;
            this.initPrefixUrl(host);
        }
    }

    @Override
    public synchronized void setProxy(String host, int port, String scheme) {
        this.proxy = new HttpHost(host, port, scheme);
    }

    @Override
    public synchronized void setTimeout(int socketTimeout, int connectTimeout) {
        this.timeout = new Timeout(socketTimeout, connectTimeout);
    }

    @Override
    public synchronized void setHttpClient(CloseableHttpClient httpClient) {
        this.customHttpClient = Objects.requireNonNull(httpClient);
    }

    private ExecutorService getThreadPool() {
        return Optional.ofNullable(this.threadPool).orElseGet(HttpExecutorFactory::getDefaultThreadPool);
    }

    @Override
    public synchronized void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public synchronized void setBasicAuth(String username, String password) {
        if (this.basicAuthInterceptorHasSet.get()) {
            this.removeInterceptors(BasicAuthInterceptor.class);
        }
        this.basicAuthCredentials = new UsernamePasswordCredentials(username, password);
        this.basicAuthInterceptorHasSet.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        RequestInvoker requestInvoker;
        if (this.prefixUrl == null) {
            requestInvoker = this;
            synchronized (requestInvoker) {
                if (this.prefixUrl == null) {
                    this.initPrefixUrl(null);
                }
            }
        }
        if (this.basicAuthCredentials != null && !this.basicAuthInterceptorHasSet.get()) {
            requestInvoker = this;
            synchronized (requestInvoker) {
                if (!this.basicAuthInterceptorHasSet.get()) {
                    this.interceptors.addFirst(new BasicAuthInterceptor(this.basicAuthCredentials.getUserName(), this.basicAuthCredentials.getPassword(), this.charset));
                    this.basicAuthInterceptorHasSet.set(true);
                }
            }
        }
    }

    @Override
    public <T> T exchange(@Nonnull String url, @Nonnull HttpMethod method, @Nonnull BodyType bodyType, @Nonnull ResponseType responseType, @Nonnull Type responseEntityType, @Nullable Map<String, String> httpHeaders, @Nullable Map<String, Object> uriVariables, @Nullable Object requestBody) {
        throw new UnsupportedOperationException("Delegate to private exchange method");
    }

    private <T> T exchange(@Nonnull Method invokeMethod, @Nonnull String url, @Nonnull HttpMethod method, @Nonnull BodyType bodyType, @Nonnull ResponseType responseType, @Nonnull Type responseEntityType, @Nullable Map<String, String> httpHeaders, @Nullable Map<String, Object> uriVariables, @Nullable Object requestBody) {
        this.doInit();
        MultiMap<String> uriVariableMultiMap = Resolver.resolveParameters(uriVariables);
        Request request = Request.Builder.newBuilder(method.name()).setPrefixUrl(this.prefixUrl).setSuffixUrl(url).addHeaders(this.headers).addHeaders(Optional.ofNullable(httpHeaders).orElseGet(Collections::emptyMap)).addParameters(this.parameters).addParameters(uriVariableMultiMap).setBody(requestBody).addQueryParameterNames(uriVariableMultiMap.keySet()).build();
        HttpInvokerSupplier supplier = new HttpInvokerSupplier(invokeMethod, request, bodyType, responseType, responseEntityType);
        if (!TypeUtil.isAsyncType(responseEntityType)) {
            return supplier.get();
        }
        return (T)CompletableFuture.supplyAsync(supplier, this.getThreadPool());
    }

    private class HttpInvokerSupplier
    implements Supplier<Object> {
        private final Method method;
        private final Request request;
        private final BodyType bodyType;
        private final ResponseType responseType;
        private final Type responseEntityType;

        HttpInvokerSupplier(Method method, Request request, RequestMethodHolder requestMethodHolder) {
            this(method, request, requestMethodHolder.getBodyType(), requestMethodHolder.getResponseType(), method.getGenericReturnType());
        }

        HttpInvokerSupplier(Method method, Request request, BodyType bodyType, ResponseType responseType, Type responseEntityType) {
            this.method = method;
            this.request = request;
            this.bodyType = bodyType;
            this.responseType = responseType;
            this.responseEntityType = responseEntityType;
        }

        @Override
        public Object get() {
            HttpResponse httpResponse;
            Object result;
            HttpExecutor executor = RequestInvoker.this.createHttpExecutor(this.bodyType);
            try {
                for (Interceptor interceptor : RequestInvoker.this.interceptors) {
                    result = interceptor.beforeRequest(this.method, this.request, this.bodyType, this.responseType, executor);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (Exception e) {
                if (e instanceof HttpClientException) {
                    throw e;
                }
                throw new HttpClientException("error executing pre interceptor", e);
            }
            try {
                httpResponse = executor.execute(this.request, this.bodyType, this.responseType);
            }
            catch (IOException e) {
                throw new HttpClientException("unexpected error on request url " + this.request.getUrl(), e);
            }
            HttpParser httpParser = RequestInvoker.this.parserFactory.getHttpParser(this.responseType);
            try {
                for (Interceptor interceptor : RequestInvoker.this.interceptors) {
                    Object result2 = interceptor.beforeParse(this.method, this.request, this.bodyType, this.responseType, httpResponse, httpParser);
                    if (result2 == null) continue;
                    IOUtil.closeQuietly(httpResponse);
                    return result2;
                }
            }
            catch (Exception e) {
                IOUtil.closeQuietly(httpResponse);
                if (e instanceof HttpClientException) {
                    throw (HttpClientException)e;
                }
                throw new HttpClientException("error executing post interceptor", e);
            }
            try {
                result = httpParser.parse(httpResponse, RequestInvoker.this.charset, this.responseEntityType);
            }
            catch (Exception e) {
                IOUtil.closeQuietly(httpResponse);
                if (e instanceof HttpClientException) {
                    throw (HttpClientException)e;
                }
                throw new HttpClientException("error parsing http response", e);
            }
            if (!(httpParser instanceof StreamHttpParser)) {
                IOUtil.closeQuietly(httpResponse);
            }
            return result;
        }
    }

    private static class RequestMethodHolder {
        private final String method;
        private final String suffixUrl;
        private final BodyType bodyType;
        private final ResponseType responseType;

        public RequestMethodHolder(String method, String suffixUrl, BodyType bodyType, ResponseType responseType) {
            this.method = method;
            this.suffixUrl = suffixUrl;
            this.bodyType = bodyType;
            this.responseType = responseType;
        }

        public String getMethod() {
            return this.method;
        }

        public String getSuffixUrl() {
            return this.suffixUrl;
        }

        public BodyType getBodyType() {
            return this.bodyType;
        }

        public ResponseType getResponseType() {
            return this.responseType;
        }
    }

    static class Timeout {
        private final int socketTimeout;
        private final int connectTimeout;

        public Timeout() {
            this(-1, -1);
        }

        public Timeout(int socketTimeout, int connectTimeout) {
            this.socketTimeout = socketTimeout;
            this.connectTimeout = connectTimeout;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public String toString() {
            return "RequestInvoker.Timeout(socketTimeout=" + this.getSocketTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ")";
        }
    }
}

