/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.proxy;

import com.ifengxue.http.annotation.Body;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.Expensive;
import com.ifengxue.http.annotation.Header;
import com.ifengxue.http.annotation.Param;
import com.ifengxue.http.annotation.ParamHeader;
import com.ifengxue.http.annotation.QueryMap;
import com.ifengxue.http.annotation.QueryParam;
import com.ifengxue.http.codec.Codec;
import com.ifengxue.http.codec.CodecFactory;
import com.ifengxue.http.codec.JsonCodec;
import com.ifengxue.http.codec.XmlCodec;
import com.ifengxue.http.collection.MultiMap;
import com.ifengxue.http.collection.MultiValueMap;
import com.ifengxue.http.contract.Callback;
import com.ifengxue.http.contract.CallbackHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class Resolver {
    Resolver() {
    }

    static MultiMap<String> resolveParameters(Map<String, Object> uriVariables) {
        if (uriVariables == null) {
            return new MultiValueMap<String>();
        }
        MultiValueMap<String> parameterMap = new MultiValueMap<String>(uriVariables.size());
        parameterMap.putAll(uriVariables);
        return parameterMap;
    }

    static MultiMap<String> resolveParameters(Method method, Object[] args, BodyType bodyType) {
        if (args == null || args.length == 0) {
            return new MultiValueMap<String>();
        }
        Parameter[] parameters = method.getParameters();
        MultiValueMap<String> parameterMap = new MultiValueMap<String>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(Body.class) || Callback.class.isAssignableFrom(parameter.getType()) || (parameter.isAnnotationPresent(Header.class) || parameter.isAnnotationPresent(ParamHeader.class)) && !parameter.isAnnotationPresent(Param.class) && !parameter.isAnnotationPresent(QueryParam.class) && !parameter.isAnnotationPresent(QueryMap.class)) continue;
            if (parameter.isAnnotationPresent(Expensive.class) || parameter.isAnnotationPresent(QueryMap.class)) {
                if (parameter.isAnnotationPresent(QueryMap.class) && !(args[i] instanceof Map)) {
                    throw new IllegalArgumentException("@QueryMap must annotated on Map type parameter.");
                }
                Codec codec = CodecFactory.findCodec(JsonCodec.class);
                if (bodyType == BodyType.APPLICATION_XML) {
                    codec = CodecFactory.findCodec(XmlCodec.class);
                }
                codec.decode(args[i]).forEach((key, value) -> parameterMap.put((String)key, Optional.ofNullable(value).orElse(null)));
                continue;
            }
            if (parameter.isAnnotationPresent(QueryParam.class)) {
                QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
                parameterMap.put(queryParam.name(), args[i]);
                continue;
            }
            Param param = parameter.getAnnotation(Param.class);
            String parameterName = Optional.ofNullable(param).map(Param::value).orElse(parameter.getName());
            parameterMap.put(parameterName, args[i]);
        }
        return parameterMap;
    }

    static Map<String, String> resolveHeaders(Method method) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Header header : (Header[])method.getDeclaringClass().getAnnotationsByType(Header.class)) {
            headerMap.put(header.name(), header.value());
        }
        for (Header header : (Header[])method.getAnnotationsByType(Header.class)) {
            headerMap.put(header.name(), header.value());
        }
        return headerMap;
    }

    static Map<String, String> resolveParamHeaders(Method method, Object[] args) {
        if (args == null) {
            return Collections.emptyMap();
        }
        Parameter[] parameters = method.getParameters();
        HashMap<String, String> headerMap = new HashMap<String, String>(args.length);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(ParamHeader.class)) continue;
            ParamHeader header = parameter.getAnnotation(ParamHeader.class);
            headerMap.put(header.name(), String.valueOf(args[i]));
        }
        return headerMap;
    }

    static Set<String> resolveQueryParameterNames(Method method, Object[] args) {
        Set<String> names = Collections.emptySet();
        for (int i = 0; i < method.getParameters().length; ++i) {
            Parameter parameter = method.getParameters()[i];
            if (parameter.isAnnotationPresent(QueryParam.class)) {
                if (names.isEmpty()) {
                    names = new LinkedHashSet<String>();
                }
                QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
                names.add(queryParam.name());
                continue;
            }
            if (!parameter.isAnnotationPresent(QueryMap.class)) continue;
            if (names.isEmpty()) {
                names = new LinkedHashSet<String>();
            }
            if (args[i] == null) continue;
            for (Object name : ((Map)args[i]).keySet()) {
                names.add(name.toString());
            }
        }
        return names;
    }

    public static Object resolveBody(Method method, Object[] args) {
        if (args == null) {
            return null;
        }
        Parameter[] parameters = method.getParameters();
        int bodyIndex = -1;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(Body.class)) continue;
            if (bodyIndex >= 0) {
                throw new IllegalArgumentException(method.getName() + " contains more than one @Body");
            }
            bodyIndex = i;
        }
        return bodyIndex >= 0 ? args[bodyIndex] : null;
    }

    public static CallbackHandler findCallbackHandler(Method method, Object[] args) {
        int[] indexes;
        if (args == null || args.length == 0) {
            return null;
        }
        for (int index : indexes = new int[]{0, args.length - 1}) {
            Parameter parameter = method.getParameters()[index];
            if (!Callback.class.isAssignableFrom(parameter.getType())) continue;
            return new CallbackHandler((Callback)Objects.requireNonNull(args[index], "Callback can't be null."), parameter);
        }
        return null;
    }
}

