/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public enum TypeUtil {

    private static Set<Type> supportAsyncTypes = new HashSet<Type>();
    private static Set<Type> builtinTypes = new HashSet<Type>();

    public static boolean isVoidType(Type rawType) {
        return TypeUtil.isPrimitiveType(rawType, Void.class);
    }

    public static <T> T resolvePrimitiveTypeValue(String value, Type primitiveType) {
        if (primitiveType == Integer.class || primitiveType == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (primitiveType == Long.class || primitiveType == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (primitiveType == Float.class || primitiveType == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (primitiveType == Double.class || primitiveType == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (primitiveType == Boolean.class || primitiveType == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (primitiveType == Short.class || primitiveType == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (primitiveType == Byte.class || primitiveType == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (primitiveType == Character.class || primitiveType == Character.TYPE) {
            if (value.length() != 1) {
                throw new IllegalStateException("can't convert " + value + " to char");
            }
            return (T)Character.valueOf(value.charAt(0));
        }
        throw new IllegalStateException("not primitive type " + primitiveType.getTypeName());
    }

    public static boolean isPrimitiveType(Type rawType) {
        return TypeUtil.isPrimitiveType(rawType, Integer.class) || TypeUtil.isPrimitiveType(rawType, Long.class) || TypeUtil.isPrimitiveType(rawType, Float.class) || TypeUtil.isPrimitiveType(rawType, Double.class) || TypeUtil.isPrimitiveType(rawType, Boolean.class) || TypeUtil.isPrimitiveType(rawType, Short.class) || TypeUtil.isPrimitiveType(rawType, Byte.class) || TypeUtil.isPrimitiveType(rawType, Character.class);
    }

    public static boolean isPrimitiveType(Type rawType, Class<?> primitiveWrapperType) {
        try {
            Field typeField = primitiveWrapperType.getField("TYPE");
            Class primitiveType = (Class)typeField.get(primitiveWrapperType);
            if (rawType == primitiveType || rawType == primitiveWrapperType) {
                return true;
            }
            return TypeUtil.isTypeOf(rawType, primitiveWrapperType);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(primitiveWrapperType.getName() + " not a primitive wrapper class.", e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isAsyncType(Type rawType) {
        if (supportAsyncTypes.contains(rawType)) {
            return true;
        }
        if (rawType instanceof ParameterizedType) {
            return supportAsyncTypes.contains(((ParameterizedType)rawType).getRawType());
        }
        return false;
    }

    public static Type findActualType(Type rawType) {
        ParameterizedType parameterizedType;
        if (rawType instanceof Class) {
            return rawType;
        }
        if (rawType instanceof ParameterizedType && builtinTypes.contains((parameterizedType = (ParameterizedType)rawType).getRawType())) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return rawType;
    }

    public static boolean isTypeOf(Type rawType, Type targetType) {
        if (rawType == targetType) {
            return true;
        }
        if (rawType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)rawType;
            if (!builtinTypes.contains(parameterizedType.getRawType())) {
                return false;
            }
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (type == targetType) {
                return true;
            }
            if (type instanceof Class && targetType instanceof Class) {
                return ((Class)type).isAssignableFrom((Class)targetType);
            }
            return false;
        }
        if (rawType instanceof Class && targetType instanceof Class) {
            return ((Class)rawType).isAssignableFrom((Class)targetType);
        }
        return false;
    }

    static {
        supportAsyncTypes.add((Type)((Object)Future.class));
        supportAsyncTypes.add((Type)((Object)CompletableFuture.class));
        builtinTypes.addAll(supportAsyncTypes);
    }
}

