/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final String DEFAULT_VERSION = "1.6.0";
    private static final String DEFAULT_REGEX = "((\\d+\\.?)+([._-](RELEASE|SNAPSHOT))?).jar";
    public static final String VERSION = Version.getVersion();

    public static String getVersion() {
        return Version.getVersion(Version.class, DEFAULT_REGEX, DEFAULT_VERSION);
    }

    public static String getVersion(Class<?> clazz) {
        return Version.getVersion(clazz, DEFAULT_REGEX, DEFAULT_VERSION);
    }

    public static String getVersion(Class<?> clazz, String regex, String defVer) {
        try {
            String version = clazz.getPackage().getImplementationVersion();
            if (Version.isNotEmpty(version)) {
                return version;
            }
            version = Version.getVersionFromMaven(clazz);
            if (Version.isNotEmpty(version)) {
                return version;
            }
            version = Version.getVersionFromJarName(clazz, regex);
            return Version.isNotEmpty(version) ? version : defVer;
        }
        catch (Exception e) {
            return defVer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromMaven(Class<?> clazz) throws IOException {
        String filePath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (Version.isEmpty(filePath)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try (InputStream is = null;){
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/maven") || !name.endsWith("pom.properties")) continue;
                is = clazz.getClassLoader().getResourceAsStream(name);
                Properties prop = new Properties();
                prop.load(is);
                String string = prop.getProperty("version");
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static String getVersionFromJarName(Class<?> clazz, String regex) {
        if (regex == null) {
            return null;
        }
        String filePath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (Version.isEmpty(filePath)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String filename = file.getName();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isNotEmpty(String text) {
        return !Version.isEmpty(text);
    }

    private static boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }
}

