/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.integration.spring;

import com.ifengxue.http.proxy.Interceptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Import;

/**
 * 启用自动创建{@link com.ifengxue.http.annotation.Rest}代理
 *
 * @see com.ifengxue.http.annotation.Rest
 * @see SpringRestIntegration
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import(RestBeanRegister.class)
@SuppressWarnings("unused")
public @interface EnableRest {

  int NOT_SET_INT = -1;

  /**
   * 被扫描的包
   */
  String[] basePackages() default {};

  /**
   * 被扫描的包
   */
  Class<?>[] basePackageClasses() default {};

  /**
   * 不被扫描的包
   */
  String[] excludePackages() default {};

  /**
   * 排除的类
   */
  Class<?>[] excludeClasses() default {};

  /**
   * 被Spring容器托管的全局拦截器（执行优先级较{@link #interceptorClasses()}高）
   */
  String[] interceptorsRef() default {};

  /**
   * 全局拦截器（执行优先级较{@link #interceptorsRef()}低）
   */
  Class<? extends Interceptor>[] interceptorClasses() default {};

  /**
   * 全局User-Agent
   */
  String userAgent() default "";

  /**
   * User-Agent
   *
   * @return User-Agent。 必须是 placeholder 形式的值
   */
  String userAgentString() default "";

  /**
   * 全局charset
   */
  String charset() default "UTF-8";

  /**
   * charset
   *
   * @return charset。 必须是 placeholder 形式的值
   */
  String charsetString() default "";

  /**
   * 数据传输过程中数据包之间间隔的最大时间
   */
  int socketTimeout() default NOT_SET_INT;

  /**
   * 数据传输过程中数据包之间间隔的最大时间
   *
   * @return 数据传输过程中数据包之间间隔的最大时间。可以是 placeholder 形式的值, 也可以是 {@link java.time.Duration#parse(CharSequence)} 形式的值
   */
  String socketTimeoutString() default "";

  /**
   * 建立TCP连接的超时时间
   */
  int connectTimeout() default NOT_SET_INT;

  /**
   * 建立TCP连接的超时时间
   *
   * @return 建立TCP连接的超时时间。可以是 placeholder 形式的值, 也可以是 {@link java.time.Duration#parse(CharSequence)} 形式的值
   */
  String connectTimeoutString() default "";
}
