/*
 * Copyright 2018 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.integration.spring;

import java.util.Map;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * {@link com.ifengxue.http.annotation.Rest}自动配置
 */
@Data
@Configuration
@ConfigurationProperties("rest")
public class RestProperties {

  /**
   * true:启用自动配置;false:停用自动配置
   */
  private boolean enabled = true;
  /**
   * 全局 headers
   */
  private Map<String, String> headers;
  /**
   * 全局 parameters
   */
  private Map<String, Object> parameters;
  /**
   * 全局 proxy host
   */
  private String proxyHost;
  /**
   * 全局 proxy port
   */
  private int proxyPort;
  /**
   * 全局 proxy scheme
   */
  private String proxyScheme;
  /**
   * 全局 socket timeout
   */
  private Integer socketTimeout;
  /**
   * 全局 connect timeout
   */
  private Integer connectTimeout;
}
