/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.integration.spring;

import java.time.Duration;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public enum SpringIntegrationUtil {
  ;

  public static int parseInt(StringValueResolver valueResolver, String expression) {
    String value = valueResolver.resolveStringValue(expression);
    try {
      if (NumberUtils.isDigits(value)) {
        return Integer.parseInt(value);
      }
      return (int) Duration.parse(value).toMillis();
    } catch (NumberFormatException e) {
      throw new IllegalArgumentException("Illegal placeholder expression '" + expression + "'", e);
    }
  }

  public static Integer parseInt(StringValueResolver valueResolver, Integer value, String expression,
      String bothHaveTextMessage) {
    if (value.compareTo(EnableRest.NOT_SET_INT) != 0 && StringUtils.hasText(expression)) {
      throw new IllegalArgumentException(bothHaveTextMessage);
    }
    if (value.compareTo(EnableRest.NOT_SET_INT) != 0) {
      return value;
    }
    if (StringUtils.isEmpty(expression)) {
      return null;
    }
    return parseInt(valueResolver, expression);
  }

  public static String parseString(StringValueResolver valueResolver, String expression) {
    return valueResolver.resolveStringValue(expression);
  }

  public static String parseString(StringValueResolver valueResolver, String value, String expression,
      String bothHaveTextMessage) {
    if (StringUtils.hasText(value) && StringUtils.hasText(expression)) {
      throw new IllegalArgumentException(bothHaveTextMessage);
    }
    if (StringUtils.hasText(value)) {
      return value;
    }
    if (StringUtils.isEmpty(expression)) {
      return null;
    }
    return parseString(valueResolver, expression);
  }
}
