/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.integration.spring;

import static com.ifengxue.http.integration.spring.EnableRest.NOT_SET_INT;

import com.ifengxue.http.proxy.Interceptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.stereotype.Component;

/**
 * spring rest integration
 *
 * @see com.ifengxue.http.annotation.Rest
 * @since 1.5.2
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Component
@Documented
public @interface SpringRestIntegration {

  /**
   * bean name
   */
  String name() default "";

  /**
   * 被Spring容器托管的拦截器（执行优先级较{@link #interceptorClasses()}高）
   */
  String[] interceptorsRef() default {};

  /**
   * 拦截器（执行优先级较{@link #interceptorsRef()}低）<br>
   * 注意：如果<code>interceptor class</code>已经被Spring容器托管，则使用容器托管的bean，否则会自行实例化一个拦截器对象
   */
  Class<? extends Interceptor>[] interceptorClasses() default {};

  /**
   * User-Agent
   */
  String userAgent() default "";

  /**
   * User-Agent
   *
   * @return User-Agent。 必须是 placeholder 形式的值
   */
  String userAgentString() default "";

  /**
   * charset
   */
  String charset() default "UTF-8";

  /**
   * charset
   *
   * @return charset。 必须是 placeholder 形式的值
   */
  String charsetString() default "";

  /**
   * 数据传输过程中数据包之间间隔的最大时间
   */
  int socketTimeout() default NOT_SET_INT;

  /**
   * 数据传输过程中数据包之间间隔的最大时间
   *
   * @return 数据传输过程中数据包之间间隔的最大时间。可以是 placeholder 形式的值, 也可以是 {@link java.time.Duration#parse(CharSequence)} 形式的值
   */
  String socketTimeoutString() default "";

  /**
   * 建立TCP连接的超时时间
   */
  int connectTimeout() default NOT_SET_INT;

  /**
   * 建立TCP连接的超时时间
   *
   * @return 建立TCP连接的超时时间。可以是 placeholder 形式的值, 也可以是 {@link java.time.Duration#parse(CharSequence)} 形式的值
   */
  String connectTimeoutString() default "";
}
