/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.integration.spring;

import com.ifengxue.http.annotation.Rest;
import com.ifengxue.http.integration.spring.EnableRest;
import com.ifengxue.http.integration.spring.SpringIntegrationUtil;
import com.ifengxue.http.integration.spring.SpringRestIntegration;
import com.ifengxue.http.proxy.HttpClientConfig;
import com.ifengxue.http.proxy.Interceptor;
import com.ifengxue.http.proxy.ProxyBuilder;
import java.beans.Introspector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringValueResolver;

public class RestBeanRegister
implements ImportBeanDefinitionRegistrar,
BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(RestBeanRegister.class);
    public static final String REST_ENABLED_NAME = "rest.enabled";
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private Environment environment;
    private ResourceLoader resourceLoader;
    private StringValueResolver valueResolver;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map attributes = Optional.ofNullable(importingClassMetadata.getAnnotationAttributes(EnableRest.class.getName())).orElseThrow(() -> new IllegalStateException("\u672a\u53d1\u73b0@EnableRest\u6807\u8bb0\u7684\u7c7b"));
        if (!((Boolean)this.environment.getProperty(REST_ENABLED_NAME, Boolean.TYPE, (Object)true)).booleanValue()) {
            log.debug("\u672a\u542f\u7528@Rest\u81ea\u52a8\u6ce8\u518c");
            return;
        }
        Set basePackages = Arrays.stream((String[])attributes.get("basePackages")).collect(Collectors.toSet());
        for (Class basePackageClass : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(basePackageClass.getPackage().getName());
        }
        if (basePackages.isEmpty()) {
            basePackages.add(this.lookupBasePackage());
        }
        Set excludePackages = Arrays.stream((String[])attributes.get("excludePackages")).collect(Collectors.toSet());
        ArrayList<Object> interceptors = new ArrayList<Object>();
        for (Class interceptorClass : (Class[])attributes.get("interceptorClasses")) {
            interceptors.add(BeanUtils.instantiateClass((Class)interceptorClass));
        }
        Set excludeClassNames = Arrays.stream((Class[])attributes.get("excludeClasses")).map(Class::getName).collect(Collectors.toSet());
        ClassPathScanningCandidateComponentProvider classScanner = this.createClassScanner();
        classScanner.setResourceLoader(this.resourceLoader);
        classScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SpringRestIntegration.class));
        classScanner.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            for (String excludePackage : excludePackages) {
                if (!metadataReader.getClassMetadata().getClassName().startsWith(excludePackage)) continue;
                return true;
            }
            return false;
        });
        classScanner.addExcludeFilter((metadataReader, metadataReaderFactory) -> excludeClassNames.contains(metadataReader.getClassMetadata().getClassName()));
        HashSet beanDefinitions = new HashSet();
        for (String basePackage : basePackages) {
            beanDefinitions.addAll(classScanner.findCandidateComponents(basePackage));
        }
        ClientConfigHolder globalClientConfigHolder = ClientConfigHolder.from(attributes, this.valueResolver);
        for (BeanDefinition beanDefinition : beanDefinitions) {
            Class clazz;
            try {
                clazz = ClassUtils.getClass((ClassLoader)this.classLoader, (String)((AnnotatedBeanDefinition)beanDefinition).getMetadata().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.debug("load class error.", (Throwable)e);
                continue;
            }
            GenericBeanDefinition genericBeanDefinition = beanDefinition instanceof GenericBeanDefinition ? (GenericBeanDefinition)beanDefinition : new GenericBeanDefinition(beanDefinition);
            genericBeanDefinition.setBeanClass(clazz);
            String[] interceptorsRef = (String[])attributes.get("interceptorsRef");
            if (interceptorsRef.length > 0) {
                genericBeanDefinition.setDependsOn(interceptorsRef);
            }
            genericBeanDefinition.setInstanceSupplier(() -> this.createProxyBean(globalClientConfigHolder, clazz, interceptors, interceptorsRef));
            SpringRestIntegration annotation = clazz.getAnnotation(SpringRestIntegration.class);
            String beanName = StringUtils.isNotBlank((CharSequence)annotation.name()) ? annotation.name() : Introspector.decapitalize(clazz.getSimpleName());
            registry.registerBeanDefinition(beanName, (BeanDefinition)genericBeanDefinition);
        }
    }

    private String lookupBasePackage() {
        for (Throwable e = new RuntimeException(); e != null; e = e.getCause()) {
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                if (!stackTraceElement.getMethodName().equals("main")) continue;
                return ClassUtils.getPackageName((String)stackTraceElement.getClassName());
            }
        }
        throw new IllegalStateException("can't find matched base package");
    }

    private Object createProxyBean(ClientConfigHolder globalClientConfigHolder, Class<?> clazz, List<Interceptor> interceptors, String[] interceptorsRef) {
        SpringRestIntegration springRestIntegration = clazz.getAnnotation(SpringRestIntegration.class);
        ArrayList<Object> newInterceptors = new ArrayList<Object>();
        if (springRestIntegration.interceptorsRef().length > 0 || springRestIntegration.interceptorClasses().length > 0) {
            for (String interceptor : springRestIntegration.interceptorsRef()) {
                newInterceptors.add(this.beanFactory.getBean(interceptor, Interceptor.class));
            }
            for (Class<? extends Interceptor> interceptorClass : springRestIntegration.interceptorClasses()) {
                Interceptor interceptor;
                block10: {
                    interceptor = null;
                    try {
                        interceptor = (Interceptor)this.beanFactory.getBean((Class)interceptorClass);
                        log.debug("find matched bean [{}]", (Object)interceptorClass.getName());
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        if (!log.isTraceEnabled()) break block10;
                        log.debug("can't find matched bean " + interceptorClass.getName(), (Throwable)e);
                    }
                }
                if (interceptor == null) {
                    interceptor = (Interceptor)BeanUtils.instantiateClass((Class)interceptorClass);
                    log.debug("can't find matched bean [{}], instantiate class success.", (Object)interceptorClass.getName());
                }
                newInterceptors.add(interceptor);
            }
        }
        for (String interceptorRef : interceptorsRef) {
            newInterceptors.add(this.beanFactory.getBean(interceptorRef, Interceptor.class));
        }
        newInterceptors.addAll(interceptors);
        String host = Optional.ofNullable(clazz.getAnnotation(Rest.class)).map(Rest::value).orElse("");
        Object proxyBean = ProxyBuilder.newBuilder().classLoader(this.classLoader).proxyInterface(clazz).host(this.valueResolver.resolveStringValue(host)).addInterceptors(newInterceptors).build();
        ClientConfigHolder clientConfigHolder = globalClientConfigHolder.merge(springRestIntegration, this.valueResolver);
        HttpClientConfig httpClientConfig = (HttpClientConfig)proxyBean;
        if (StringUtils.isNotEmpty((CharSequence)clientConfigHolder.getCharset())) {
            httpClientConfig.setCharset(Charset.forName(clientConfigHolder.getCharset()));
        }
        if (StringUtils.isNotEmpty((CharSequence)clientConfigHolder.getUserAgent())) {
            httpClientConfig.setUserAgent(clientConfigHolder.getUserAgent());
        }
        if (clientConfigHolder.getSocketTimeout() != null && clientConfigHolder.getConnectTimeout() != null) {
            httpClientConfig.setTimeout(clientConfigHolder.getSocketTimeout().intValue(), clientConfigHolder.getConnectTimeout().intValue());
        }
        return proxyBean;
    }

    private ClassPathScanningCandidateComponentProvider createClassScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isInterface();
            }
        };
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.valueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private static class ClientConfigHolder {
        private String userAgent;
        private String charset;
        private Integer socketTimeout;
        private Integer connectTimeout;

        private static ClientConfigHolder from(Map<String, Object> attributes, StringValueResolver valueResolver) {
            Integer connectTimeout;
            ClientConfigHolder holder = new ClientConfigHolder();
            holder.setUserAgent(SpringIntegrationUtil.parseString(valueResolver, (String)attributes.get("userAgent"), (String)attributes.get("userAgentString"), "userAgent and userAgentString cannot be set at the same time"));
            holder.setCharset(SpringIntegrationUtil.parseString(valueResolver, (String)attributes.get("charset"), (String)attributes.get("charsetString"), "charset and charsetString cannot be set at the same time"));
            Integer socketTimeout = SpringIntegrationUtil.parseInt(valueResolver, (Integer)attributes.get("socketTimeout"), (String)attributes.get("socketTimeoutString"), "socketTimeout and socketTimeoutString cannot be set at the same time");
            if (socketTimeout != null) {
                holder.setSocketTimeout(socketTimeout);
            }
            if ((connectTimeout = SpringIntegrationUtil.parseInt(valueResolver, (Integer)attributes.get("connectTimeout"), (String)attributes.get("connectTimeoutString"), "connectTimeout and connectTimeoutString cannot be set at the same time")) != null) {
                holder.setConnectTimeout(connectTimeout);
            }
            return holder;
        }

        private ClientConfigHolder merge(SpringRestIntegration annotation, StringValueResolver valueResolver) {
            Integer newConnectTimeout;
            Integer newSocketTimeout;
            String newCharset;
            ClientConfigHolder clone = new ClientConfigHolder();
            clone.setUserAgent(this.userAgent);
            clone.setCharset(this.charset);
            clone.setSocketTimeout(this.socketTimeout);
            clone.setConnectTimeout(this.connectTimeout);
            String newUserAgent = SpringIntegrationUtil.parseString(valueResolver, annotation.userAgent(), annotation.userAgentString(), "userAgent and userAgentString cannot be set at the same time");
            if (StringUtils.isNotBlank((CharSequence)newUserAgent)) {
                clone.setUserAgent(newUserAgent);
            }
            if (StringUtils.isNotBlank((CharSequence)(newCharset = SpringIntegrationUtil.parseString(valueResolver, annotation.charset(), annotation.charsetString(), "charset and charsetString cannot be set at the same time")))) {
                clone.setCharset(newCharset);
            }
            if ((newSocketTimeout = SpringIntegrationUtil.parseInt(valueResolver, annotation.socketTimeout(), annotation.socketTimeoutString(), "socketTimeout and socketTimeoutString cannot be set at the same time")) != null) {
                clone.setSocketTimeout(newSocketTimeout);
            }
            if ((newConnectTimeout = SpringIntegrationUtil.parseInt(valueResolver, annotation.connectTimeout(), annotation.connectTimeoutString(), "connectTimeout and connectTimeoutString cannot be set at the same time")) != null) {
                clone.setConnectTimeout(newConnectTimeout);
            }
            return clone;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getCharset() {
            return this.charset;
        }

        public Integer getSocketTimeout() {
            return this.socketTimeout;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfigHolder)) {
                return false;
            }
            ClientConfigHolder other = (ClientConfigHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
                return false;
            }
            Integer this$socketTimeout = this.getSocketTimeout();
            Integer other$socketTimeout = other.getSocketTimeout();
            if (this$socketTimeout == null ? other$socketTimeout != null : !((Object)this$socketTimeout).equals(other$socketTimeout)) {
                return false;
            }
            Integer this$connectTimeout = this.getConnectTimeout();
            Integer other$connectTimeout = other.getConnectTimeout();
            return !(this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientConfigHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            Integer $socketTimeout = this.getSocketTimeout();
            result = result * 59 + ($socketTimeout == null ? 43 : ((Object)$socketTimeout).hashCode());
            Integer $connectTimeout = this.getConnectTimeout();
            result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
            return result;
        }

        public String toString() {
            return "RestBeanRegister.ClientConfigHolder(userAgent=" + this.getUserAgent() + ", charset=" + this.getCharset() + ", socketTimeout=" + this.getSocketTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ")";
        }
    }
}

