/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.integration.spring;

import java.time.Duration;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public enum SpringIntegrationUtil {


    public static int parseInt(StringValueResolver valueResolver, String expression) {
        String value = valueResolver.resolveStringValue(expression);
        try {
            if (NumberUtils.isDigits((String)value)) {
                return Integer.parseInt(value);
            }
            return (int)Duration.parse(value).toMillis();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal placeholder expression '" + expression + "'", e);
        }
    }

    public static Integer parseInt(StringValueResolver valueResolver, Integer value, String expression, String bothHaveTextMessage) {
        if (value.compareTo(-1) != 0 && StringUtils.hasText((String)expression)) {
            throw new IllegalArgumentException(bothHaveTextMessage);
        }
        if (value.compareTo(-1) != 0) {
            return value;
        }
        if (StringUtils.isEmpty((Object)expression)) {
            return null;
        }
        return SpringIntegrationUtil.parseInt(valueResolver, expression);
    }

    public static String parseString(StringValueResolver valueResolver, String expression) {
        return valueResolver.resolveStringValue(expression);
    }

    public static String parseString(StringValueResolver valueResolver, String value, String expression, String bothHaveTextMessage) {
        if (StringUtils.hasText((String)value) && StringUtils.hasText((String)expression)) {
            throw new IllegalArgumentException(bothHaveTextMessage);
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        if (StringUtils.isEmpty((Object)expression)) {
            return null;
        }
        return SpringIntegrationUtil.parseString(valueResolver, expression);
    }
}

