/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.commons.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final Pattern EXTRACTOR = Pattern.compile("^([^\\d\\.]+)-|\\.?([\\d]+)|-?(.*)$");
    private static final long serialVersionUID = -4409642391893263592L;
    private final long[] numericParts;
    private final String prefix;
    private final String postfix;
    private final int hash;

    public Version(String string) {
        if (string == null) {
            this.prefix = "";
            this.postfix = "";
            this.numericParts = new long[0];
        } else {
            ArrayList<Long> detectedDigits = new ArrayList<Long>();
            Matcher matcher = EXTRACTOR.matcher(string.trim());
            String tail = "";
            String start = "";
            while (matcher.find()) {
                String grpStart = matcher.group(1);
                String grpNum = matcher.group(2);
                String grpTail = matcher.group(3);
                if (grpStart != null) {
                    start = grpStart;
                    continue;
                }
                if (grpNum != null) {
                    detectedDigits.add(Long.parseLong(grpNum));
                    continue;
                }
                if (grpTail == null) continue;
                tail = grpTail;
                break;
            }
            this.numericParts = new long[detectedDigits.size()];
            for (int i = 0; i < detectedDigits.size(); ++i) {
                this.numericParts[i] = (Long)detectedDigits.get(i);
            }
            this.postfix = tail;
            this.prefix = start;
        }
        this.hash = this.toString().hashCode();
    }

    public Version(long ... parts) {
        this(null, parts, null);
    }

    public Version(String prefix, long[] numericParts, String postfix) {
        this.prefix = prefix == null ? "" : prefix.trim();
        this.postfix = postfix == null ? "" : postfix.trim();
        this.numericParts = new long[numericParts == null ? 0 : numericParts.length];
        if (numericParts != null) {
            for (int i = 0; i < numericParts.length; ++i) {
                this.numericParts[i] = Math.abs(numericParts[i]);
            }
        }
        this.hash = this.toString().hashCode();
    }

    public Version changePrefix(String prefix) {
        return new Version(prefix, this.numericParts, this.postfix);
    }

    public Version changePostfix(String postfix) {
        return new Version(this.prefix, this.numericParts, postfix);
    }

    public Version changeNumeric(long ... numericParts) {
        return new Version(this.prefix, numericParts, this.postfix);
    }

    public long getNumericPartAtPosition(int position) {
        return position < 0 || position >= this.numericParts.length ? 0L : this.numericParts[position];
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public long getMajor() {
        return this.getNumericPartAtPosition(0);
    }

    public long getMinor() {
        return this.getNumericPartAtPosition(1);
    }

    public long getMicro() {
        return this.getNumericPartAtPosition(2);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Version) {
            Version that = (Version)obj;
            result = this.prefix.equals(that.prefix) && Arrays.equals(this.numericParts, that.numericParts) && this.postfix.equals(that.postfix);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.prefix.isEmpty()) {
            result.append(this.prefix);
        }
        if (this.numericParts.length > 0) {
            if (result.length() > 0) {
                result.append('-');
            }
            boolean nofirst = false;
            for (long i : this.numericParts) {
                if (nofirst) {
                    result.append('.');
                }
                result.append(Long.toString(i));
                nofirst = true;
            }
        }
        if (!this.postfix.isEmpty()) {
            if (result.length() > 0 && result.charAt(result.length() - 1) != '-') {
                result.append('-');
            }
            result.append(this.postfix);
        }
        return result.toString();
    }

    @Override
    public int compareTo(Version version) {
        String thatPrefix = version.prefix;
        String thatPostfix = version.postfix;
        long[] thatNumbers = version.numericParts;
        int comparePrefix = this.prefix.compareTo(thatPrefix);
        if (comparePrefix != 0) {
            return comparePrefix;
        }
        int maxnum = Math.max(this.numericParts.length, thatNumbers.length);
        for (int i = 0; i < maxnum; ++i) {
            int result;
            long y;
            long x = i < this.numericParts.length ? this.numericParts[i] : 0L;
            long l = y = i < thatNumbers.length ? thatNumbers[i] : 0L;
            int n = x < y ? -1 : (result = x == y ? 0 : 1);
            if (result == 0) continue;
            return result;
        }
        return this.postfix.compareTo(thatPostfix);
    }

    public boolean isNumericPartPresented() {
        return this.numericParts.length > 0;
    }
}

