/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.commons.version;

import com.igormaznitsa.commons.version.Version;
import com.igormaznitsa.commons.version.operators.DefaultExpressionParser;
import com.igormaznitsa.commons.version.operators.ExpressionParser;
import com.igormaznitsa.commons.version.operators.Operator;
import java.io.Serializable;

public final class VersionValidator
implements Serializable {
    private static final long serialVersionUID = 641987018021820537L;
    private final Operator expressionRoot;
    private static final ExpressionParser DEFAULT_EXPRESSION_PARSER = new DefaultExpressionParser();

    public VersionValidator(Operator expressionRoot) {
        this.expressionRoot = expressionRoot;
    }

    public VersionValidator(String expression) {
        this(expression, DEFAULT_EXPRESSION_PARSER);
    }

    public VersionValidator(String expression, ExpressionParser parser) {
        this(expression == null ? null : parser.parse(expression));
    }

    public Operator getExpressionRoot() {
        return this.expressionRoot;
    }

    public boolean isValid(Version version) {
        boolean result = false;
        if (this.expressionRoot != null) {
            result = this.expressionRoot.isValid(version);
        }
        return result;
    }

    public String toString() {
        return VersionValidator.class.getSimpleName() + (this.expressionRoot == null ? "[]" : '[' + this.expressionRoot.toString() + ']');
    }
}

