/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.commons.version.operators;

import com.igormaznitsa.commons.version.Version;
import com.igormaznitsa.commons.version.operators.Condition;
import com.igormaznitsa.commons.version.operators.ExpressionParser;
import com.igormaznitsa.commons.version.operators.Operator;
import com.igormaznitsa.commons.version.operators.OperatorAnd;
import com.igormaznitsa.commons.version.operators.OperatorLeaf;
import com.igormaznitsa.commons.version.operators.OperatorOr;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DefaultExpressionParser
implements ExpressionParser {
    private static final long serialVersionUID = 2676755912472640998L;
    private static final Pattern PATTERN_LEAF = Pattern.compile("(!=|>=|<=|>|<|=)\\s*(.*)");
    private static final Pattern PATTERN_OR = Pattern.compile("(.+)\\;(.+)");
    private static final Pattern PATTERN_AND = Pattern.compile("(.+)\\,(.+)");

    @Override
    public Operator parse(String text) {
        Operator result = null;
        if (text != null) {
            Matcher leaf;
            Matcher andMatcher;
            String trimmed = text.trim();
            Matcher orMatcher = PATTERN_OR.matcher(trimmed);
            result = orMatcher.matches() ? new OperatorOr(this.parse(orMatcher.group(1)), this.parse(orMatcher.group(2))) : ((andMatcher = PATTERN_AND.matcher(trimmed)).matches() ? new OperatorAnd(this.parse(andMatcher.group(1)), this.parse(andMatcher.group(2))) : ((leaf = PATTERN_LEAF.matcher(trimmed)).matches() ? new OperatorLeaf(Condition.decode(leaf.group(1)), new Version(leaf.group(2))) : new OperatorLeaf(Condition.EQU, new Version(trimmed))));
        }
        return result;
    }
}

