/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.commons.version.operators;

import com.igormaznitsa.commons.version.Version;
import com.igormaznitsa.commons.version.operators.Condition;
import com.igormaznitsa.commons.version.operators.Operator;

public final class OperatorLeaf
implements Operator {
    private static final long serialVersionUID = -4529836368426048811L;
    private final Condition op;
    private final Version base;

    public OperatorLeaf(Condition op, Version base) {
        this.op = op;
        this.base = base;
    }

    @Override
    public boolean isValid(Version version) {
        if (version != null) {
            int result = this.base.compareTo(version);
            switch (this.op) {
                case UNKNOWN: {
                    throw new IllegalArgumentException("Detected illegal condition");
                }
                case EQU: {
                    return result == 0;
                }
                case NOT_EQU: {
                    return result != 0;
                }
                case LESS: {
                    return result > 0;
                }
                case GREAT: {
                    return result < 0;
                }
                case LESS_OR_EQU: {
                    return result >= 0;
                }
                case GREAT_OR_EQU: {
                    return result <= 0;
                }
            }
            throw new Error("Detected unexpected operation : " + (Object)((Object)this.op));
        }
        return false;
    }

    public String toString() {
        return this.op.toString() + this.base.toString();
    }
}

