/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser;

import com.igormaznitsa.prologparser.PrologParser;
import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.exceptions.PrologParserException;
import com.igormaznitsa.prologparser.terms.PrologAtom;
import com.igormaznitsa.prologparser.terms.PrologNumeric;
import com.igormaznitsa.prologparser.terms.PrologStruct;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.tokenizer.Op;
import com.igormaznitsa.prologparser.tokenizer.OpAssoc;
import com.igormaznitsa.prologparser.tokenizer.TermWrapper;
import java.util.ArrayList;

final class AstItem {
    private final PrologTerm savedTerm;
    private AstItem leftItem;
    private AstItem rightItem;
    private AstItem parentItem;

    AstItem(PrologTerm term, int line, int pos) {
        if (term == null) {
            this.savedTerm = null;
        } else {
            TermType termType = term.getType();
            this.savedTerm = termType == TermType.OPERATOR ? new TermWrapper(term) : term;
            this.savedTerm.setPos(pos);
            this.savedTerm.setLine(line);
        }
    }

    int getPrecedence() {
        return this.savedTerm.getPrecedence();
    }

    AstItem makeAsRightBranch(AstItem item) {
        AstItem curRightChild = this.rightItem;
        this.setRightBranch(item);
        item.setLeftBranch(curRightChild);
        AstItem result = this;
        if (item.getType() == TermType.OPERATOR && item.getPrecedence() != 0) {
            result = item;
        }
        return result;
    }

    AstItem makeAsOwnerWithLeftBranch(AstItem item) {
        this.replaceForOwner(item);
        item.setLeftBranch(this);
        return item;
    }

    AstItem getRightBranch() {
        return this.rightItem;
    }

    private void setRightBranch(AstItem item) {
        this.rightItem = item;
        if (item != null) {
            item.parentItem = this;
        }
    }

    private AstItem getLeftBranch() {
        return this.leftItem;
    }

    private void setLeftBranch(AstItem item) {
        this.leftItem = item;
        if (item != null) {
            item.parentItem = this;
        }
    }

    TermType getType() {
        return this.savedTerm.getType();
    }

    AstItem findRoot() {
        AstItem theParent;
        AstItem result = this;
        while ((theParent = result.parentItem) != null) {
            result = theParent;
        }
        return result;
    }

    AstItem findFirstNodeWithSuchOrLowerPrecedence(int precedence) {
        AstItem itsParent;
        AstItem result = this;
        while ((itsParent = result.parentItem) != null && result.getPrecedence() < precedence) {
            result = itsParent;
        }
        return result;
    }

    private void replaceForOwner(AstItem newItem) {
        if (this.parentItem == null) {
            newItem.parentItem = null;
            return;
        }
        if (this == this.parentItem.getLeftBranch()) {
            this.parentItem.setLeftBranch(newItem);
        } else {
            this.parentItem.setRightBranch(newItem);
        }
    }

    OpAssoc getOpAssoc() {
        return ((Op)((TermWrapper)this.savedTerm).getWrappedTerm()).getAssoc();
    }

    private boolean isOperandsOk() {
        if (this.savedTerm.getType() == TermType.OPERATOR) {
            Op wrappedOperator = (Op)((TermWrapper)this.savedTerm).getWrappedTerm();
            switch (wrappedOperator.getAssoc()) {
                case FX: 
                case FY: {
                    return this.leftItem == null && this.rightItem != null;
                }
                case YF: 
                case XF: {
                    return this.leftItem != null && this.rightItem == null;
                }
                case XFX: 
                case XFY: 
                case YFX: {
                    return this.leftItem != null && this.rightItem != null;
                }
            }
            throw new CriticalUnexpectedError();
        }
        return this.leftItem == null && this.rightItem == null;
    }

    private boolean isPrecedenceOk() {
        if (this.savedTerm.getType() == TermType.OPERATOR) {
            int thisPrecedence = this.getPrecedence();
            Op wrappedOperator = (Op)((TermWrapper)this.savedTerm).getWrappedTerm();
            switch (wrappedOperator.getAssoc()) {
                case FX: {
                    return this.leftItem == null && this.rightItem != null && this.rightItem.getPrecedence() < thisPrecedence;
                }
                case FY: {
                    return this.leftItem == null && this.rightItem != null && this.rightItem.getPrecedence() <= thisPrecedence;
                }
                case YF: {
                    return this.leftItem != null && this.leftItem.getPrecedence() <= thisPrecedence && this.rightItem == null;
                }
                case XF: {
                    return this.leftItem != null && this.leftItem.getPrecedence() < thisPrecedence && this.rightItem == null;
                }
                case XFX: {
                    return this.leftItem != null && this.leftItem.getPrecedence() < thisPrecedence && this.rightItem != null && this.rightItem.getPrecedence() < thisPrecedence;
                }
                case XFY: {
                    return this.leftItem != null && this.leftItem.getPrecedence() < thisPrecedence && this.rightItem != null && this.rightItem.getPrecedence() <= thisPrecedence;
                }
                case YFX: {
                    return this.leftItem != null && this.leftItem.getPrecedence() <= thisPrecedence && this.rightItem != null && this.rightItem.getPrecedence() < thisPrecedence;
                }
            }
            throw new CriticalUnexpectedError();
        }
        return this.leftItem == null && this.rightItem == null;
    }

    private boolean isAnyBlock() {
        return this.savedTerm.getType() == TermType.STRUCT && (this.savedTerm.getFunctor() == Op.VIRTUAL_OPERATOR_BLOCK || this.savedTerm.getFunctor() == Op.VIRTUAL_OPERATOR_CURLY_BLOCK);
    }

    private boolean isBlock() {
        return this.savedTerm.getType() == TermType.STRUCT && this.savedTerm.getFunctor() == Op.VIRTUAL_OPERATOR_BLOCK;
    }

    private boolean isOperator() {
        return this.savedTerm.getType() == TermType.OPERATOR;
    }

    public String toString() {
        return "TreeItem[" + (this.savedTerm == null ? "null" : this.savedTerm.toString()) + ']';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PrologTerm convertToTermAndRelease(PrologParser parser) {
        switch (this.savedTerm.getType()) {
            case OPERATOR: {
                PrologStruct operatorStruct;
                PrologNumeric numeric;
                PrologTerm right;
                PrologTerm left;
                TermWrapper wrapper = (TermWrapper)this.savedTerm;
                if (this.leftItem == null && this.rightItem == null) {
                    return new PrologAtom(wrapper.getWrappedTerm().getText(), wrapper.getQuotation(), wrapper.getPos(), wrapper.getLine());
                }
                if (this.leftItem == null) {
                    if (this.rightItem.getType() == TermType.STRUCT && this.rightItem.savedTerm.isAnyBlock() && !((PrologStruct)this.rightItem.savedTerm).isEmpty()) {
                        PrologTerm rightTerm = this.rightItem.convertToTermAndRelease(parser);
                        Op operator = (Op)wrapper.getWrappedTerm();
                        PrologTerm blockContent = ((PrologStruct)rightTerm).getTermAt(0);
                        if (blockContent.getType() == TermType.STRUCT) {
                            PrologTerm[] terms = blockContent.flatComma(new ArrayList<PrologTerm>()).toArray(PrologParser.EMPTY_TERM_ARRAY);
                            if (operator.getArity() == terms.length) {
                                return new PrologStruct((PrologTerm)operator, terms, wrapper.getLine(), wrapper.getPos());
                            }
                            Op appropriateOperator = parser.getContext().findOpForName(parser, operator.getText()).findForArity(terms.length);
                            if (appropriateOperator != null) return new PrologStruct((PrologTerm)appropriateOperator, terms, wrapper.getLine(), wrapper.getPos());
                            if (operator.getArity() != 1) return new PrologStruct((PrologTerm)new PrologAtom(wrapper.getText(), Quotation.SINGLE, wrapper.getLine(), wrapper.getPos()), terms, wrapper.getLine(), wrapper.getPos());
                            return new PrologStruct((PrologTerm)operator, new PrologTerm[]{blockContent}, wrapper.getLine(), wrapper.getPos());
                        }
                        if (rightTerm.isCurlyBlock()) {
                            return new PrologStruct((PrologTerm)operator, new PrologTerm[]{rightTerm}, wrapper.getLine(), wrapper.getPos());
                        }
                        if (operator.getArity() != 1) return (operator = parser.getContext().findOpForName(parser, operator.getText()).findForArity(1)) == null ? new PrologStruct((PrologTerm)new PrologAtom(wrapper.getText(), Quotation.SINGLE, wrapper.getLine(), wrapper.getPos()), new PrologTerm[]{blockContent}, wrapper.getLine(), wrapper.getPos()) : new PrologStruct((PrologTerm)operator, new PrologTerm[]{blockContent}, wrapper.getLine(), wrapper.getPos());
                        return new PrologStruct((PrologTerm)operator, new PrologTerm[]{blockContent}, wrapper.getLine(), wrapper.getPos());
                    }
                } else if (this.isAnyBlock() && this.leftItem.isAnyBlock()) {
                    return new PrologStruct(wrapper.getWrappedTerm(), new PrologTerm[]{this.leftItem.convertToTermAndRelease(parser)}, wrapper.getLine(), wrapper.getPos());
                }
                if (!this.isOperandsOk()) {
                    throw new PrologParserException("No operands: [" + wrapper.getText() + ']', wrapper.getLine(), wrapper.getPos());
                }
                if (!this.isPrecedenceOk()) {
                    if (this.rightItem == null) throw new PrologParserException("Operator precedence clash or missing operator: [" + wrapper.getText() + ']', wrapper.getLine(), wrapper.getPos());
                    if (!this.rightItem.isOperator()) throw new PrologParserException("Operator precedence clash or missing operator: [" + wrapper.getText() + ']', wrapper.getLine(), wrapper.getPos());
                    if (!this.rightItem.getOpAssoc().isPrefix()) throw new PrologParserException("Operator precedence clash or missing operator: [" + wrapper.getText() + ']', wrapper.getLine(), wrapper.getPos());
                    left = this.leftItem == null ? null : this.leftItem.convertToTermAndRelease(parser);
                    right = new PrologStruct((PrologTerm)Op.VIRTUAL_OPERATOR_BLOCK, new PrologTerm[]{this.rightItem.convertToTermAndRelease(parser)});
                } else {
                    left = this.leftItem == null ? null : this.leftItem.convertToTermAndRelease(parser);
                    PrologTerm prologTerm = right = this.rightItem == null ? null : this.rightItem.convertToTermAndRelease(parser);
                }
                if ("-".equals(wrapper.getText()) && left == null && right instanceof PrologNumeric && !(numeric = (PrologNumeric)right).isNegative()) {
                    return ((PrologNumeric)right).makeNeg();
                }
                if (left == null) {
                    operatorStruct = new PrologStruct(wrapper.getWrappedTerm(), new PrologTerm[]{right}, wrapper.getLine(), wrapper.getPos());
                    return operatorStruct;
                } else {
                    PrologTerm[] prologTermArray;
                    PrologTerm prologTerm = wrapper.getWrappedTerm();
                    if (right == null) {
                        PrologTerm[] prologTermArray2 = new PrologTerm[1];
                        prologTermArray = prologTermArray2;
                        prologTermArray2[0] = left;
                    } else {
                        PrologTerm[] prologTermArray3 = new PrologTerm[2];
                        prologTermArray3[0] = left;
                        prologTermArray = prologTermArray3;
                        prologTermArray3[1] = right;
                    }
                    operatorStruct = new PrologStruct(prologTerm, prologTermArray, wrapper.getLine(), wrapper.getPos());
                }
                return operatorStruct;
            }
            case STRUCT: {
                PrologStruct thisStruct = (PrologStruct)this.savedTerm;
                if (thisStruct.getFunctor() != Op.VIRTUAL_OPERATOR_BLOCK) {
                    if (thisStruct.getFunctor() != Op.VIRTUAL_OPERATOR_CURLY_BLOCK) return thisStruct;
                }
                if (thisStruct.getArity() != 1) return thisStruct;
                PrologTerm thatTerm = thisStruct.getTermAt(0);
                if (thatTerm.getType() != TermType.STRUCT) return thisStruct;
                if (thatTerm.getFunctor() == Op.VIRTUAL_OPERATOR_BLOCK) return thatTerm.isBlock() && this.isBlock() && (this.parentItem == null || this.parentItem.isBlock()) ? thatTerm : thisStruct;
                if (thatTerm.getFunctor() != Op.VIRTUAL_OPERATOR_CURLY_BLOCK) return thisStruct;
                return thatTerm.isBlock() && this.isBlock() && (this.parentItem == null || this.parentItem.isBlock()) ? thatTerm : thisStruct;
            }
            default: {
                return this.savedTerm;
            }
        }
    }
}

