/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser;

import com.igormaznitsa.prologparser.ParserContext;
import com.igormaznitsa.prologparser.PrologParser;
import com.igormaznitsa.prologparser.terms.OpContainer;
import com.igormaznitsa.prologparser.tokenizer.Op;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultParserContext
implements ParserContext {
    protected static final Op[] EMPTY = new Op[0];
    protected final Set<String> opPrefixes = new HashSet<String>();
    protected final Map<String, OpContainer> opContainers = new HashMap<String, OpContainer>();
    protected final int parserContextFlags;

    public DefaultParserContext(int parserContextFlags) {
        this.parserContextFlags = parserContextFlags;
    }

    public static ParserContext of(int parserContextFlags) {
        return new DefaultParserContext(parserContextFlags);
    }

    public static ParserContext of(int parserContextFlags, Op ... operators) {
        return new DefaultParserContext(parserContextFlags).addOps(operators);
    }

    @SafeVarargs
    public static ParserContext of(int parserContextFlags, List<Op> ... operators) {
        return new DefaultParserContext(parserContextFlags).addOps(operators);
    }

    public Map<String, OpContainer> findAllOperators() {
        return Collections.unmodifiableMap(this.opContainers);
    }

    @Override
    public int getFlags() {
        return this.parserContextFlags;
    }

    protected void fillPrefixes(String name) {
        IntStream.rangeClosed(1, name.length()).mapToObj(i -> name.substring(0, i)).forEach(this.opPrefixes::add);
    }

    @SafeVarargs
    public final DefaultParserContext addOps(List<Op> ... operators) {
        Stream.of(operators).filter(Objects::nonNull).forEach(ops -> this.addOps(ops.toArray(EMPTY)));
        return this;
    }

    public DefaultParserContext addOps(Op ... operators) {
        Stream.of(operators).filter(Objects::nonNull).flatMap(Op::streamOp).forEach(x -> {
            this.fillPrefixes(x.getText());
            OpContainer container = this.opContainers.get(x.getText());
            if (container == null) {
                container = OpContainer.make(x);
                this.opContainers.put(x.getText(), container);
            } else {
                container.add((Op)x);
            }
        });
        return this;
    }

    @Override
    public boolean hasOpStartsWith(PrologParser source, String operatorNameStartSubstring) {
        return this.opPrefixes.contains(operatorNameStartSubstring);
    }

    @Override
    public OpContainer findOpForName(PrologParser source, String operatorName) {
        return this.opContainers.get(operatorName);
    }
}

