/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser;

import com.igormaznitsa.prologparser.ParserContext;
import com.igormaznitsa.prologparser.PrologParser;
import com.igormaznitsa.prologparser.terms.OpContainer;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class ParserContextChain
implements ParserContext {
    private final ParserContext[] contexts;
    private final int tokenizerFlags;
    private final int minDetectedAllowedBufferSize;

    public ParserContextChain(ParserContext ... contexts) {
        this.contexts = (ParserContext[])Arrays.stream(contexts).filter(Objects::nonNull).toArray(ParserContext[]::new);
        this.minDetectedAllowedBufferSize = Stream.of(this.contexts).mapToInt(ParserContext::getMaxTokenizerBufferLength).min().orElse(Integer.MAX_VALUE);
        this.tokenizerFlags = Arrays.stream(this.contexts).mapToInt(ParserContext::getFlags).reduce(0, (a, b) -> a | b);
    }

    public static ParserContext of(ParserContext ... contexts) {
        ParserContext result = contexts.length == 1 ? Objects.requireNonNull(contexts[0]) : new ParserContextChain(contexts);
        return result;
    }

    @Override
    public int getMaxTokenizerBufferLength() {
        return this.minDetectedAllowedBufferSize;
    }

    @Override
    public boolean hasOpStartsWith(PrologParser source, String namePrefix) {
        boolean result = false;
        for (ParserContext c : this.contexts) {
            if (!c.hasOpStartsWith(source, namePrefix)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public OpContainer findOpForName(PrologParser source, String name) {
        ParserContext c;
        OpContainer result = null;
        ParserContext[] parserContextArray = this.contexts;
        int n = parserContextArray.length;
        for (int i = 0; i < n && (result = (c = parserContextArray[i]).findOpForName(source, name)) == null; ++i) {
        }
        return result;
    }

    @Override
    public int getFlags() {
        return this.tokenizerFlags;
    }
}

