/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser;

import com.igormaznitsa.prologparser.AstItem;
import com.igormaznitsa.prologparser.DefaultParserContext;
import com.igormaznitsa.prologparser.ParserContext;
import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.exceptions.PrologParserException;
import com.igormaznitsa.prologparser.terms.OpContainer;
import com.igormaznitsa.prologparser.terms.PrologAtom;
import com.igormaznitsa.prologparser.terms.PrologList;
import com.igormaznitsa.prologparser.terms.PrologStruct;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.tokenizer.Op;
import com.igormaznitsa.prologparser.tokenizer.OpAssoc;
import com.igormaznitsa.prologparser.tokenizer.Tokenizer;
import com.igormaznitsa.prologparser.tokenizer.TokenizerResult;
import com.igormaznitsa.prologparser.utils.Koi7CharOpMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class PrologParser
implements Iterable<PrologTerm>,
Closeable {
    public static final PrologTerm[] EMPTY_TERM_ARRAY = new PrologTerm[0];
    protected static final Koi7CharOpMap META_OP_MAP = Koi7CharOpMap.ofOps(new OpContainer[0]);
    private static final OpContainer OPERATOR_COMMA;
    private static final OpContainer OPERATOR_LEFTBRACKET;
    private static final OpContainer OPERATOR_LEFTCURLYBRACKET;
    private static final OpContainer OPERATOR_RIGHTBRACKET;
    private static final OpContainer OPERATOR_RIGHTCURLYBRACKET;
    private static final OpContainer OPERATOR_RIGHTSQUAREBRACKET;
    private static final OpContainer OPERATOR_DOT;
    private static final OpContainer OPERATOR_VERTICALBAR;
    private static final Koi7CharOpMap OPERATORS_PHRASE;
    private static final Koi7CharOpMap OPERATORS_INSIDE_LIST;
    private static final Koi7CharOpMap OPERATORS_END_LIST;
    private static final Koi7CharOpMap OPERATORS_INSIDE_STRUCT;
    private static final Koi7CharOpMap OPERATORS_SUBBLOCK;
    private static final Koi7CharOpMap OPERATORS_SUBBLOCK_CURLY;
    private volatile boolean autoCloseReaderFlag;
    protected final ParserContext context;
    protected final int parserFlags;
    private final Tokenizer tokenizer;

    public PrologParser(Reader source, ParserContext context) {
        this.context = context == null ? DefaultParserContext.of(0) : context;
        this.tokenizer = new Tokenizer(this, META_OP_MAP, Objects.requireNonNull(source));
        this.parserFlags = context == null ? 0 : context.getFlags();
    }

    public PrologParser autoCloseReader() {
        this.autoCloseReaderFlag = true;
        return this;
    }

    public static Op findBaseMetaOperator(String text, OpAssoc type) {
        if (text.length() != 1) {
            return null;
        }
        OpContainer container = META_OP_MAP.get(text);
        if (container == null) {
            container = META_OP_MAP.get(text);
        }
        Op result = null;
        if (container != null) {
            result = container.findForType(type);
        }
        return result;
    }

    private static int getOnlyCharCode(String text) {
        if (text == null || text.length() != 1) {
            return -1;
        }
        return text.charAt(0);
    }

    public static Koi7CharOpMap findMetaOps() {
        return Koi7CharOpMap.copyOf(META_OP_MAP);
    }

    public Tokenizer getInternalTokenizer() {
        return this.tokenizer;
    }

    private boolean isEndOperator(PrologTerm operator, Koi7CharOpMap endOperators) {
        if (operator == null) {
            return true;
        }
        if (endOperators == null) {
            return false;
        }
        return operator.getType() == TermType.OPERATOR && endOperators.contains(operator.getText());
    }

    public ParserContext getContext() {
        return this.context;
    }

    public boolean hasNext() {
        return this.tokenizer.peek() != null;
    }

    public PrologTerm next() {
        PrologTerm found = this.readBlock(OPERATORS_PHRASE);
        if (found == null) {
            throw new NoSuchElementException("No terms in source");
        }
        TokenizerResult endAtom = this.tokenizer.readNextToken();
        if (endAtom == null || !endAtom.getResult().getText().equals(OPERATOR_DOT.getText())) {
            throw new PrologParserException("End operator is not found", this.tokenizer.getLine(), this.tokenizer.getPos());
        }
        return found;
    }

    private PrologStruct readStruct(PrologTerm functor) {
        ArrayList<PrologTerm> listOfAtoms = new ArrayList<PrologTerm>();
        boolean active = true;
        block4: while (active) {
            PrologTerm block = this.readBlock(OPERATORS_INSIDE_STRUCT);
            if (block == null) {
                return null;
            }
            TokenizerResult nextAtom = this.tokenizer.readNextToken();
            if (nextAtom == null) {
                throw new PrologParserException("Can't read next token in block", this.tokenizer.getLine(), this.tokenizer.getPos());
            }
            String nextText = nextAtom.getResult().getText();
            switch (PrologParser.getOnlyCharCode(nextText)) {
                case 44: {
                    listOfAtoms.add(block);
                    continue block4;
                }
                case 41: {
                    listOfAtoms.add(block);
                    active = false;
                    continue block4;
                }
            }
            throw new PrologParserException("Unexpected term in structure: " + nextText, nextAtom.getLine(), nextAtom.getPos());
        }
        PrologStruct result = new PrologStruct(functor, listOfAtoms.toArray(EMPTY_TERM_ARRAY));
        return result;
    }

    private PrologTerm readList(TokenizerResult openingBracket) {
        PrologList leftPart;
        PrologList leftPartFirst = leftPart = new PrologList();
        PrologTerm rightPart = null;
        boolean hasSeparator = false;
        boolean doRead = true;
        block5: while (doRead) {
            PrologTerm block = this.readBlock(OPERATORS_INSIDE_LIST);
            TokenizerResult nextAtom = this.tokenizer.readNextToken();
            if (nextAtom == null) {
                throw new PrologParserException("Can't read next token in list", this.tokenizer.getLine(), this.tokenizer.getPos());
            }
            String text = nextAtom.getResult().getText();
            switch (PrologParser.getOnlyCharCode(text)) {
                case 93: {
                    doRead = false;
                    if (block != null) break;
                    continue block5;
                }
                case 124: {
                    this.checkForNull(block, "There is not any list element", openingBracket);
                    if (leftPartFirst.isEmpty()) {
                        leftPartFirst = PrologList.setTermAsNewListTail(leftPart, block);
                    } else {
                        PrologList.setTermAsNewListTail(leftPart, block);
                    }
                    hasSeparator = true;
                    rightPart = this.readBlock(OPERATORS_END_LIST);
                    if (rightPart != null && rightPart.getType() == TermType.STRUCT && rightPart.getFunctor().getText().equals(OPERATOR_VERTICALBAR.getText())) {
                        throw new PrologParserException("Duplicated list tail definition", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos(), null);
                    }
                    TokenizerResult nextAtomTwo = this.tokenizer.readNextToken();
                    if (nextAtomTwo == null) {
                        throw new PrologParserException("Can't find expected token in list", this.tokenizer.getLine(), this.tokenizer.getPos());
                    }
                    if (!nextAtomTwo.getResult().getText().equals(OPERATOR_RIGHTSQUAREBRACKET.getText())) {
                        throw new PrologParserException("Wrong end of the list tail", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
                    }
                    doRead = false;
                    continue block5;
                }
                case 44: {
                    this.checkForNull(block, "List element not found", nextAtom);
                    break;
                }
                default: {
                    throw new CriticalUnexpectedError();
                }
            }
            if (leftPartFirst.isEmpty()) {
                leftPart = leftPartFirst = PrologList.setTermAsNewListTail(leftPart, block);
                continue;
            }
            leftPart = PrologList.setTermAsNewListTail(leftPart, block);
        }
        if (hasSeparator) {
            if (rightPart == null) {
                throw new PrologParserException("There is not any term as the tail at the list", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
            }
            if (rightPart.getType() == TermType.STRUCT && (rightPart.getFunctor() == Op.METAOPERATOR_COMMA || rightPart.getFunctor() == Op.METAOPERATOR_VERTICAL_BAR)) {
                throw new PrologParserException("Unexpected comma or bar in rest of list", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
            }
            if (rightPart.getType() == TermType.ATOM && rightPart.getQuotation() == Quotation.NONE && ",".equals(rightPart.getText())) {
                throw new PrologParserException("Comma operator in list tail", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
            }
            leftPartFirst.replaceEndListElement(rightPart);
        }
        return leftPartFirst;
    }

    private void checkForNull(Object obj, String message, TokenizerResult startTerm) {
        if (obj == null) {
            throw new PrologParserException(message, startTerm.getLine(), startTerm.getPos());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private PrologTerm readBlock(Koi7CharOpMap endOperators) {
        AstItem currentTreeItem = null;
        block8: while (!Thread.currentThread().isInterrupted()) {
            int readAtomPrecedence;
            PrologTerm readAtom;
            TokenizerResult readAtomContainer;
            block43: {
                TokenizerResult nextToken;
                block45: {
                    block44: {
                        readAtomContainer = this.tokenizer.readNextToken();
                        if (readAtomContainer == null) {
                            if (currentTreeItem != null) throw new PrologParserException("Non-ended clause", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
                            return null;
                        }
                        readAtom = readAtomContainer.getResult();
                        if (this.isEndOperator(readAtom, endOperators)) {
                            this.tokenizer.push(readAtomContainer);
                            break;
                        }
                        readAtomPrecedence = 0;
                        if (!(readAtom instanceof OpContainer)) break block44;
                        Op readOperator = ((OpContainer)readAtom).getIfSingle();
                        if (readOperator == null) {
                            TokenizerResult peekResult;
                            boolean rightPresented;
                            OpContainer readOperators = (OpContainer)readAtom;
                            boolean leftPresented = false;
                            if (currentTreeItem != null) {
                                if (currentTreeItem.getType() == TermType.OPERATOR) {
                                    if (currentTreeItem.getRightBranch() != null) {
                                        leftPresented = true;
                                    }
                                } else {
                                    leftPresented = true;
                                }
                            }
                            if ((readAtom = readOperators.findSimilar(leftPresented, rightPresented = (peekResult = this.tokenizer.peek()) != null && !this.isEndOperator(peekResult.getResult(), endOperators))) == null) {
                                if (currentTreeItem != null) throw new PrologParserException("Operator clash detected [" + readAtomContainer.getResult().getText() + ']', readAtomContainer.getLine(), readAtomContainer.getPos());
                                if (rightPresented) throw new PrologParserException("Operator clash detected [" + readAtomContainer.getResult().getText() + ']', readAtomContainer.getLine(), readAtomContainer.getPos());
                                return new PrologAtom(readOperators.getText(), Quotation.SINGLE, readOperators.getLine(), readOperators.getPos());
                            }
                            readAtomPrecedence = readAtom.getPrecedence();
                            break block43;
                        } else {
                            readAtom = readOperator;
                            String operatorText = readOperator.getText();
                            if (operatorText.length() == 1) {
                                int onlyCharCode = PrologParser.getOnlyCharCode(operatorText);
                                switch (onlyCharCode) {
                                    case 91: {
                                        readAtom = this.readList(readAtomContainer);
                                        readAtom.setPos(readAtomContainer.getPos());
                                        readAtom.setLine(readAtomContainer.getLine());
                                        break;
                                    }
                                    case 40: 
                                    case 123: {
                                        boolean processReadAtom = true;
                                        if (onlyCharCode == 40) {
                                            readAtom = this.readBlock(OPERATORS_SUBBLOCK);
                                        } else if ((this.parserFlags & 0x10) == 0) {
                                            readAtomPrecedence = readOperator.getPrecedence();
                                            processReadAtom = false;
                                        } else {
                                            readAtom = this.readBlock(OPERATORS_SUBBLOCK_CURLY);
                                        }
                                        if (!processReadAtom) break;
                                        boolean emptyCurly = false;
                                        if (readAtom == null) {
                                            if (onlyCharCode != 123) {
                                                throw new PrologParserException("Illegal start of term", readAtomContainer.getLine(), readAtomContainer.getPos());
                                            }
                                            emptyCurly = true;
                                        }
                                        if (emptyCurly) {
                                            readAtom = new PrologStruct((PrologTerm)Op.VIRTUAL_OPERATOR_CURLY_BLOCK, EMPTY_TERM_ARRAY, readAtomContainer.getLine(), readAtomContainer.getPos());
                                        } else {
                                            readAtom.setLine(readAtomContainer.getLine());
                                            readAtom.setPos(readAtomContainer.getPos());
                                            readAtom = new PrologStruct((PrologTerm)(onlyCharCode == 123 ? Op.VIRTUAL_OPERATOR_CURLY_BLOCK : Op.VIRTUAL_OPERATOR_BLOCK), new PrologTerm[]{readAtom}, readAtomContainer.getLine(), readAtomContainer.getPos());
                                        }
                                        TokenizerResult token = this.tokenizer.readNextToken();
                                        PrologTerm closingAtom = token == null ? null : token.getResult();
                                        if (closingAtom == null) throw new PrologParserException("Non-closed brackets: " + onlyCharCode, this.tokenizer.getLine(), this.tokenizer.getPos());
                                        if (closingAtom.getText().equals((onlyCharCode == 123 ? OPERATOR_RIGHTCURLYBRACKET : OPERATOR_RIGHTBRACKET).getText())) break;
                                        throw new PrologParserException("Non-closed brackets: " + onlyCharCode, this.tokenizer.getLine(), this.tokenizer.getPos());
                                    }
                                    default: {
                                        readAtomPrecedence = readOperator.getPrecedence();
                                        break;
                                    }
                                }
                                break block43;
                            } else {
                                readAtomPrecedence = readOperator.getPrecedence();
                            }
                        }
                        break block43;
                    }
                    if (readAtom.getType() == TermType.VAR && (this.parserFlags & 4) == 0) break block43;
                    nextToken = this.tokenizer.readNextToken();
                    if (nextToken == null) {
                        throw new PrologParserException("Non-closed clause", this.tokenizer.getLastTokenLine(), this.tokenizer.getLastTokenPos());
                    }
                    if (!nextToken.getResult().getText().equals(OPERATOR_LEFTBRACKET.getText())) break block45;
                    int nextTokenLineNumber = nextToken.getLine();
                    int nextTokenStrPosition = nextToken.getPos();
                    if (readAtom.getType() == TermType.ATOM || readAtom.getType() == TermType.VAR && (this.parserFlags & 4) != 0) {
                        PrologTerm prev = readAtom;
                        if ((readAtom = this.readStruct(readAtom)) == null) {
                            if ((this.parserFlags & 8) == 0) {
                                throw new PrologParserException("Empty structure is not allowed", nextTokenLineNumber, nextTokenStrPosition);
                            }
                            TokenizerResult pushed = this.tokenizer.pop();
                            if (pushed.getResult() != OPERATOR_RIGHTBRACKET) {
                                throw new CriticalUnexpectedError();
                            }
                            readAtom = new PrologStruct(prev);
                        }
                        break block43;
                    } else {
                        this.tokenizer.push(nextToken);
                        throw new PrologParserException("You must have an atom as the structure functor", nextTokenLineNumber, nextTokenStrPosition);
                    }
                }
                this.tokenizer.push(nextToken);
            }
            AstItem readAtomTreeItem = new AstItem(readAtom, readAtomContainer.getLine(), readAtomContainer.getPos());
            if (currentTreeItem == null) {
                currentTreeItem = readAtomTreeItem;
                continue;
            }
            if (currentTreeItem.getType() == TermType.OPERATOR) {
                if (currentTreeItem.getPrecedence() <= readAtomPrecedence) {
                    if (readAtom.getType() == TermType.OPERATOR && ((Op)readAtom).getAssoc().isPrefix()) {
                        currentTreeItem = currentTreeItem.makeAsRightBranch(readAtomTreeItem);
                        continue;
                    }
                    AstItem foundItem = currentTreeItem.findFirstNodeWithSuchOrLowerPrecedence(readAtomPrecedence);
                    if (foundItem.getPrecedence() < readAtomPrecedence) {
                        currentTreeItem = foundItem.makeAsOwnerWithLeftBranch(readAtomTreeItem);
                        continue;
                    }
                    if (foundItem.getPrecedence() > readAtomPrecedence) {
                        currentTreeItem = foundItem.makeAsRightBranch(readAtomTreeItem);
                        continue;
                    }
                    switch (foundItem.getOpAssoc()) {
                        case XF: 
                        case YF: 
                        case FX: 
                        case XFX: 
                        case YFX: {
                            currentTreeItem = foundItem.makeAsOwnerWithLeftBranch(readAtomTreeItem);
                            continue block8;
                        }
                        case FY: 
                        case XFY: {
                            currentTreeItem = foundItem.makeAsRightBranch(readAtomTreeItem);
                            continue block8;
                        }
                    }
                    throw new CriticalUnexpectedError();
                }
                if (currentTreeItem.getPrecedence() <= readAtomPrecedence) continue;
                if (readAtomTreeItem.getType() != TermType.OPERATOR && currentTreeItem.getRightBranch() != null) {
                    throw new PrologParserException("There is no any operator before the atom", readAtomContainer.getLine(), readAtomContainer.getPos());
                }
                currentTreeItem = currentTreeItem.makeAsRightBranch(readAtomTreeItem);
                continue;
            }
            if (currentTreeItem.getType() != TermType.OPERATOR && readAtomTreeItem.getType() != TermType.OPERATOR) {
                throw new PrologParserException("There must be an operator between atoms or structures", readAtomContainer.getLine(), readAtomContainer.getPos());
            }
            currentTreeItem = currentTreeItem.makeAsOwnerWithLeftBranch(readAtomTreeItem);
        }
        if (currentTreeItem == null) {
            return null;
        }
        PrologTerm result = currentTreeItem.findRoot().convertToTermAndRelease(this);
        if ((this.parserFlags & 0x20) == 0) return result;
        if (result.getType() != TermType.STRUCT) return result;
        if (!result.getText().equals(".")) return result;
        if (result.getArity() != 2) return result;
        PrologStruct asStruct = (PrologStruct)result;
        return new PrologList(asStruct.getTermAt(0), asStruct.getTermAt(1));
    }

    @Override
    public Iterator<PrologTerm> iterator() {
        return new Iterator<PrologTerm>(){

            @Override
            public boolean hasNext() {
                return PrologParser.this.hasNext();
            }

            @Override
            public PrologTerm next() {
                return PrologParser.this.next();
            }
        };
    }

    public Stream<PrologTerm> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
    }

    @Override
    public void close() throws IOException {
        this.tokenizer.close(this.autoCloseReaderFlag);
    }

    static {
        OPERATOR_DOT = META_OP_MAP.add(Op.METAOPERATOR_DOT);
        OPERATOR_LEFTBRACKET = META_OP_MAP.add(Op.METAOPERATOR_LEFT_BRACKET);
        OPERATOR_LEFTCURLYBRACKET = META_OP_MAP.add(Op.METAOPERATOR_LEFT_CURLY_BRACKET);
        OPERATOR_RIGHTBRACKET = META_OP_MAP.add(Op.METAOPERATOR_RIGHT_BRACKET);
        OPERATOR_RIGHTCURLYBRACKET = META_OP_MAP.add(Op.METAOPERATOR_RIGHT_CURLY_BRACKET);
        META_OP_MAP.add(Op.METAOPERATOR_LEFT_SQUARE_BRACKET);
        OPERATOR_RIGHTSQUAREBRACKET = META_OP_MAP.add(Op.METAOPERATOR_RIGHT_SQUARE_BRACKET);
        OPERATOR_VERTICALBAR = META_OP_MAP.add(Op.METAOPERATOR_VERTICAL_BAR);
        OPERATOR_COMMA = META_OP_MAP.add(Op.METAOPERATOR_COMMA);
        OPERATORS_PHRASE = Koi7CharOpMap.ofOps(OPERATOR_DOT);
        OPERATORS_INSIDE_LIST = Koi7CharOpMap.ofOps(OPERATOR_COMMA, OPERATOR_RIGHTSQUAREBRACKET, OPERATOR_VERTICALBAR);
        OPERATORS_END_LIST = Koi7CharOpMap.ofOps(OPERATOR_RIGHTSQUAREBRACKET);
        OPERATORS_INSIDE_STRUCT = Koi7CharOpMap.ofOps(OPERATOR_COMMA, OPERATOR_RIGHTBRACKET);
        OPERATORS_SUBBLOCK = Koi7CharOpMap.ofOps(OPERATOR_RIGHTBRACKET);
        OPERATORS_SUBBLOCK_CURLY = Koi7CharOpMap.ofOps(OPERATOR_RIGHTCURLYBRACKET);
    }
}

