/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.terms.InternalSpecialCompoundTerm;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.tokenizer.Op;
import com.igormaznitsa.prologparser.tokenizer.OpAssoc;
import com.igormaznitsa.prologparser.utils.StringBuilderEx;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OpContainer
extends InternalSpecialCompoundTerm {
    private static final long serialVersionUID = 4946799717661204529L;
    private Op opFZ;
    private Op opZF;
    private Op opZFZ;
    private int numberAtContainer;

    private OpContainer(Op operator) {
        super(operator.getText());
        operator.streamOp().forEach(this::add);
    }

    private OpContainer(String text, Op fz, Op zf, Op zfz) {
        super(text);
        this.opFZ = fz;
        this.opZF = zf;
        this.opZFZ = zfz;
        this.numberAtContainer = (fz == null ? 0 : 1) + (zf == null ? 0 : 1) + (zfz == null ? 0 : 1);
    }

    public static OpContainer make(Op operator) {
        return new OpContainer(operator);
    }

    public static OpContainer make(String text, Op fz, Op zf, Op zfz) {
        return new OpContainer(text, fz, zf, zfz);
    }

    public boolean add(Op operator) {
        if (!this.getText().equals(operator.getText())) {
            throw new IllegalArgumentException("Illegal operator name, must be '" + this.getText() + "'");
        }
        switch (operator.getAssoc()) {
            case FX: 
            case FY: {
                if (this.opFZ != null) {
                    return false;
                }
                this.opFZ = operator;
                ++this.numberAtContainer;
                break;
            }
            case XF: 
            case YF: {
                if (this.opZF != null) {
                    return false;
                }
                this.opZF = operator;
                ++this.numberAtContainer;
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: {
                if (this.opZFZ != null) {
                    return false;
                }
                this.opZFZ = operator;
                ++this.numberAtContainer;
                break;
            }
            default: {
                throw new CriticalUnexpectedError();
            }
        }
        return true;
    }

    public void clear() {
        this.opFZ = null;
        this.opZF = null;
        this.opZFZ = null;
        this.numberAtContainer = 0;
    }

    public Op findForArity(int arity) {
        Op result;
        switch (arity) {
            case 1: {
                if (this.opFZ != null) {
                    result = this.opFZ;
                    break;
                }
                result = this.opZF;
                break;
            }
            case 2: {
                result = this.opZFZ;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public boolean remove(Op op) {
        if (!this.getText().equals(op.getText())) {
            throw new IllegalArgumentException("Unexpected operator: " + op);
        }
        boolean result = false;
        if (op.equals(this.opFZ)) {
            this.opFZ = null;
            --this.numberAtContainer;
            result = true;
        } else if (op.equals(this.opZF)) {
            this.opZF = null;
            --this.numberAtContainer;
            result = true;
        } else if (op.equals(this.opZFZ)) {
            this.opZFZ = null;
            --this.numberAtContainer;
            result = true;
        }
        return result;
    }

    @Override
    public TermType getType() {
        return TermType.OPERATOR;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public PrologTerm getTermAt(int position) {
        throw new UnsupportedOperationException("Can't get element from operator container");
    }

    public int size() {
        return this.numberAtContainer;
    }

    public Op getIfSingle() {
        Op found = null;
        if (this.numberAtContainer == 1) {
            found = this.opZFZ != null ? this.opZFZ : (this.opFZ != null ? this.opFZ : this.opZF);
        }
        return found;
    }

    public Op findSimilar(boolean hasLeftArg, boolean hasRightArg) {
        Op result = hasLeftArg ? (hasRightArg ? (this.opZFZ != null ? this.opZFZ : (this.opFZ != null ? this.opFZ : this.opZF)) : (this.opZF != null ? this.opZF : this.opFZ)) : (hasRightArg ? (this.opFZ != null ? this.opFZ : this.opZF) : null);
        return result;
    }

    public Op findForType(OpAssoc type) {
        Op result = null;
        switch (type) {
            case FX: 
            case FY: {
                if (this.opFZ == null) break;
                result = this.opFZ;
                break;
            }
            case XF: 
            case YF: {
                if (this.opZF == null) break;
                result = this.opZF;
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: {
                if (this.opZFZ == null) break;
                result = this.opZFZ;
                break;
            }
            default: {
                throw new CriticalUnexpectedError();
            }
        }
        return result == null || result.getAssoc() != type ? null : result;
    }

    public Op findSimilar(OpAssoc type) {
        Op result;
        switch (type) {
            case FX: 
            case FY: {
                result = this.opFZ;
                break;
            }
            case XF: 
            case YF: {
                result = this.opZF;
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: {
                result = this.opZFZ;
                break;
            }
            default: {
                throw new CriticalUnexpectedError();
            }
        }
        return result;
    }

    public boolean removeForType(OpAssoc type) {
        boolean result = false;
        switch (type) {
            case FX: 
            case FY: {
                if (this.opFZ == null || this.opFZ.getAssoc() != type) break;
                this.opFZ = null;
                result = true;
                break;
            }
            case XF: 
            case YF: {
                if (this.opZF == null || this.opZF.getAssoc() != type) break;
                this.opZF = null;
                result = true;
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: {
                if (this.opZFZ == null || this.opZFZ.getAssoc() != type) break;
                this.opZFZ = null;
                result = true;
                break;
            }
            default: {
                throw new CriticalUnexpectedError();
            }
        }
        return result;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuilderEx result = new StringBuilderEx("OpContainer ");
        result.append(Stream.of(this.opFZ, this.opZF, this.opZFZ).filter(Objects::nonNull).map(Op::toString).collect(Collectors.joining(" ", "[", "]")));
        return result.toString();
    }
}

