/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.terms.PrologNumeric;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public final class PrologFloat
extends PrologNumeric {
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
    private static final long serialVersionUID = -8375787317103140082L;
    private final BigDecimal value;

    public PrologFloat(String text) {
        this(new BigDecimal(text, MATH_CONTEXT));
    }

    public PrologFloat(String text, int line, int pos) {
        this(new BigDecimal(text, MATH_CONTEXT), line, pos);
    }

    public PrologFloat(double value) {
        this(BigDecimal.valueOf(value));
    }

    public PrologFloat(double value, int line, int pos) {
        this(BigDecimal.valueOf(value), line, pos);
    }

    public PrologFloat(BigDecimal value) {
        this.value = Objects.requireNonNull(value);
    }

    public PrologFloat(BigDecimal value, int line, int pos) {
        super(line, pos);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public PrologNumeric makeNeg() {
        return new PrologFloat(this.value.negate());
    }

    public BigDecimal getFloatValue() {
        return this.value;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public String toString() {
        String result = this.value.toEngineeringString();
        return result.indexOf(46) < 0 ? result + ".0" : result;
    }

    @Override
    public boolean isNegative() {
        return this.value.signum() < 0;
    }
}

