/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.terms.PrologNumeric;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public final class PrologInt
extends PrologNumeric {
    private static final long serialVersionUID = 6955747225309951985L;
    private static final Map<String, BigInteger> cachedValues;
    private final BigInteger value;

    public PrologInt(String text) {
        this.value = PrologInt.valueOf(text);
    }

    public PrologInt(String text, int line, int pos) {
        this(PrologInt.valueOf(text), line, pos);
    }

    public PrologInt(long value) {
        this(BigInteger.valueOf(value));
    }

    public PrologInt(long value, int line, int pos) {
        this(BigInteger.valueOf(value), line, pos);
    }

    public PrologInt(BigInteger value) {
        this.value = Objects.requireNonNull(value);
    }

    public PrologInt(BigInteger value, int line, int pos) {
        super(line, pos);
        this.value = Objects.requireNonNull(value);
    }

    private static BigInteger valueOf(String text) {
        BigInteger result = null;
        if (PrologInt.assertNonEmptyString(text).charAt(0) == '-') {
            if (text.length() < 4) {
                result = cachedValues.get(text);
            }
        } else if (text.length() < 3) {
            result = cachedValues.get(text);
        }
        if (result == null) {
            result = new BigInteger(text, 10);
        }
        return result;
    }

    @Override
    public PrologNumeric makeNeg() {
        return new PrologInt(this.value.negate());
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    public BigInteger getIntValue() {
        return this.value;
    }

    @Override
    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    static {
        HashMap map = new HashMap();
        IntStream.range(-99, 100).forEach(x -> map.put(String.valueOf(x), BigInteger.valueOf(x)));
        cachedValues = Collections.unmodifiableMap(map);
    }
}

