/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.terms.PrologAtom;
import com.igormaznitsa.prologparser.terms.PrologStruct;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.PrologVar;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.utils.StringBuilderEx;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class PrologList
extends PrologStruct
implements Iterable<PrologTerm> {
    public static final PrologTerm LIST_FUNCTOR = new PrologAtom(".", Quotation.SINGLE);
    private static final long serialVersionUID = -3781631438477816869L;
    private static final PrologVar EMPTY_ANONYMOUS_VAR = new PrologVar("_");

    public PrologList() {
        super(LIST_FUNCTOR, 2);
        this.elements[0] = null;
        this.elements[1] = null;
    }

    public PrologList(int line, int pos) {
        this();
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologList(PrologTerm[] array) {
        this();
        for (PrologTerm prologTerm : array) {
            this.addAsNewListToEndOfListChain(prologTerm);
        }
    }

    public PrologList(PrologTerm[] array, int line, int pos) {
        this(array);
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologList(PrologTerm head) {
        this();
        this.setHead(head);
        this.setTail(new PrologList());
    }

    public PrologList(PrologTerm head, int line, int pos) {
        this(head);
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologList(PrologTerm head, PrologTerm tail) {
        this();
        this.setHead(head);
        this.setTail(tail);
    }

    public PrologList(PrologTerm head, PrologTerm tail, int line, int pos) {
        this(head, tail);
        this.setPos(pos);
        this.setLine(line);
    }

    public static PrologList setTermAsNewListTail(PrologList list, PrologTerm term) {
        PrologList result = list;
        if (list.isEmpty()) {
            list.setHead(term);
            list.setTail(new PrologList());
        } else {
            result = new PrologList(term, new PrologList());
            list.setTail(result);
        }
        return result;
    }

    @Override
    public PrologTerm getTermAt(int index) {
        PrologTerm result = super.getTermAt(index);
        return result == null ? EMPTY_ANONYMOUS_VAR : result;
    }

    @Override
    public boolean isEmpty() {
        return this.elements[0] == null && this.elements[1] == null;
    }

    public PrologTerm getHead() {
        return this.elements[0];
    }

    public void setHead(PrologTerm term) {
        this.setElementAt(0, term);
        if (this.elements[1] == null) {
            this.setTail(new PrologList());
        }
    }

    public PrologTerm getTail() {
        return this.elements[1];
    }

    public void setTail(PrologTerm term) {
        this.setElementAt(1, term);
        if (this.elements[0] == null) {
            this.setHead(EMPTY_ATOM);
        }
    }

    public PrologList addAsNewListToEndOfListChain(PrologTerm term) {
        PrologList result = this;
        if (this.isEmpty()) {
            this.setHead(term);
            this.setTail(new PrologList());
        } else {
            while (!Thread.currentThread().isInterrupted()) {
                if (result.isEmpty()) {
                    result.setHead(term);
                    result.setTail(new PrologList());
                    break;
                }
                PrologTerm leftTail = result.elements[1];
                if (leftTail.getType() == TermType.LIST) {
                    result = (PrologList)leftTail;
                    continue;
                }
                PrologList newOne = new PrologList(term, new PrologList());
                result.setTail(newOne);
                result = newOne;
                break;
            }
        }
        return result;
    }

    public void replaceEndListElement(PrologTerm newTailElement) {
        PrologList current = this;
        while (!Thread.currentThread().isInterrupted()) {
            PrologTerm tail = current.elements[1];
            if (tail.getType() == TermType.LIST) {
                PrologList leftTail = (PrologList)tail;
                if (leftTail.isEmpty()) {
                    current.setTail(newTailElement);
                    break;
                }
            } else {
                current.setTail(newTailElement);
                break;
            }
            current = (PrologList)tail;
        }
    }

    @Override
    public int getArity() {
        return this.isEmpty() ? 0 : 2;
    }

    @Override
    public void setElementAt(int index, PrologTerm term) {
        if (index < 0 || index >= 2) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.elements[index] = Objects.requireNonNull(term);
    }

    @Override
    public TermType getType() {
        return TermType.LIST;
    }

    @Override
    public String toString() {
        String result = "[]";
        if (!this.isEmpty()) {
            StringBuilderEx builder = new StringBuilderEx("[");
            boolean notFirst = false;
            PrologTerm list = this;
            while (!Thread.currentThread().isInterrupted()) {
                PrologList asList;
                if (((PrologTerm)list).getType() == TermType.LIST) {
                    PrologTerm currentHead;
                    asList = list;
                    if (asList.isEmpty()) break;
                    if (notFirst) {
                        builder.append(", ");
                    }
                    if ((currentHead = asList.elements[0]) != null) {
                        builder.append(currentHead.toString());
                    }
                } else {
                    if (notFirst) {
                        builder.append('|');
                    }
                    builder.append(((PrologTerm)list).toString());
                    break;
                }
                list = asList.elements[1];
                notFirst = true;
            }
            builder.append(']');
            result = builder.toString();
        }
        return result;
    }

    @Override
    public Iterator<PrologTerm> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new Iterator<PrologTerm>(){
            private PrologTerm head;
            private PrologTerm tail;
            {
                this.head = PrologList.this.elements[0];
                this.tail = PrologList.this.elements[1];
            }

            @Override
            public boolean hasNext() {
                return this.head != null;
            }

            @Override
            public PrologTerm next() {
                if (this.head == null) {
                    throw new NoSuchElementException();
                }
                PrologTerm result = this.head;
                if (this.tail == null) {
                    this.head = null;
                } else if (this.tail instanceof PrologList) {
                    PrologList nextList = (PrologList)this.tail;
                    this.head = nextList.elements[0];
                    this.tail = nextList.elements[1];
                } else {
                    this.head = this.tail;
                    this.tail = null;
                }
                return result;
            }
        };
    }

    @Override
    public Stream<PrologTerm> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }
}

