/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.terms.InternalSpecialCompoundTerm;
import com.igormaznitsa.prologparser.terms.PrologAtom;
import com.igormaznitsa.prologparser.terms.PrologCompound;
import com.igormaznitsa.prologparser.terms.PrologNumeric;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.tokenizer.Op;
import com.igormaznitsa.prologparser.utils.StringBuilderEx;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PrologStruct
extends PrologCompound
implements Iterable<PrologTerm> {
    public static final PrologAtom EMPTY_ATOM = new PrologAtom("", Quotation.SINGLE);
    private static final long serialVersionUID = 9000641998734217154L;
    protected final PrologTerm functor;
    protected final PrologTerm[] elements;

    public PrologStruct(PrologTerm functor, PrologTerm[] elements) {
        super(functor.getText());
        this.functor = PrologStruct.assertFunctor(functor);
        this.elements = Objects.requireNonNull((PrologTerm[])elements.clone());
    }

    public PrologStruct(PrologTerm functor, PrologTerm[] elements, int line, int pos) {
        this(functor, elements);
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologStruct(String text) {
        this((PrologTerm)new PrologAtom(text), 0);
    }

    public PrologStruct(String text, int line, int pos) {
        this(text);
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologStruct(PrologTerm functor) {
        this(functor, 0);
    }

    public PrologStruct(PrologTerm functor, int line, int pos) {
        this(functor);
        this.setPos(pos);
        this.setLine(line);
    }

    protected PrologStruct(PrologTerm functor, int arity) {
        super(functor.getText());
        if (arity < 0) {
            throw new IllegalArgumentException("Negative arity");
        }
        this.functor = PrologStruct.assertFunctor(functor);
        this.elements = new PrologTerm[arity];
        Arrays.fill(this.elements, EMPTY_ATOM);
    }

    protected PrologStruct(PrologTerm functor, int arity, int line, int pos) {
        this(functor, arity);
        this.setPos(pos);
        this.setLine(line);
    }

    private static PrologTerm assertFunctor(PrologTerm functor) {
        if (functor.getType() == TermType.LIST || functor instanceof InternalSpecialCompoundTerm) {
            throw new IllegalArgumentException("Non-allowed functor type: " + (Object)((Object)functor.getType()));
        }
        if (functor instanceof PrologNumeric) {
            throw new IllegalArgumentException("Functor can't be number: " + functor);
        }
        return functor;
    }

    @Override
    public TermType getType() {
        return TermType.STRUCT;
    }

    @Override
    public int getArity() {
        return this.elements.length;
    }

    @Override
    public PrologTerm getTermAt(int index) {
        return this.elements[index];
    }

    public void setElementAt(int index, PrologTerm term) {
        if (index < 0 || index >= this.getArity()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.elements[index] = Objects.requireNonNull(term);
    }

    @Override
    public PrologTerm getFunctor() {
        return this.functor;
    }

    @Override
    public int getPrecedence() {
        if (this.functor.getType() == TermType.OPERATOR) {
            return this.functor.getPrecedence();
        }
        return 0;
    }

    public PrologStruct copyWithAnotherFunctor(PrologTerm newFunctor) {
        return new PrologStruct(newFunctor, this.elements);
    }

    @Override
    public boolean isAnyBlock() {
        return this.functor == Op.VIRTUAL_OPERATOR_BLOCK || this.functor == Op.VIRTUAL_OPERATOR_CURLY_BLOCK;
    }

    @Override
    public boolean isCurlyBlock() {
        return this.functor == Op.VIRTUAL_OPERATOR_CURLY_BLOCK;
    }

    @Override
    public boolean isBlock() {
        return this.functor == Op.VIRTUAL_OPERATOR_BLOCK;
    }

    @Override
    public List<PrologTerm> flatComma(List<PrologTerm> list) {
        if (this.functor == Op.METAOPERATOR_COMMA) {
            for (PrologTerm t : this.elements) {
                t.flatComma(list);
            }
        } else {
            super.flatComma(list);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilderEx builder = new StringBuilderEx(64);
        if (this.functor.getType() == TermType.OPERATOR) {
            if (this.isAnyBlock()) {
                if (this.isCurlyBlock()) {
                    if (this.isEmpty()) {
                        builder.append("{}");
                    } else {
                        builder.append('{').append(this.elements[0].toString()).append('}');
                    }
                } else if (this.isEmpty()) {
                    builder.append("()");
                } else {
                    builder.append('(').append(this.elements[0].toString()).append(')');
                }
            } else {
                Op operatorFunctor = (Op)this.functor;
                String opName = operatorFunctor.getText();
                int functorPrecedence = operatorFunctor.getPrecedence();
                PrologTerm arg1 = this.getTermAt(0);
                String text1 = this.getTermAt(0).toString();
                PrologTerm arg2 = this.getArity() > 1 ? this.getTermAt(1) : null;
                String text2 = arg2 == null ? null : this.getTermAt(1).toString();
                switch (operatorFunctor.getAssoc()) {
                    case FX: {
                        builder.append(opName).append(' ');
                        if (arg1.isBlock() || arg1.getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                            break;
                        }
                        builder.append(text1);
                        break;
                    }
                    case FY: {
                        builder.append(opName);
                        builder.append(' ');
                        if (arg1.isBlock() || arg1.getPrecedence() > functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                            break;
                        }
                        builder.append(text1);
                        break;
                    }
                    case XF: {
                        if (arg1.isBlock() || arg1.getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                        } else {
                            builder.append(text1);
                        }
                        builder.append(' ').append(opName);
                        break;
                    }
                    case YF: {
                        if (arg1.isBlock() || arg1.getPrecedence() > functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                        } else {
                            builder.append(text1);
                        }
                        builder.append(' ').append(opName);
                        break;
                    }
                    case XFX: {
                        if (arg1.getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                        } else {
                            builder.append(text1);
                        }
                        builder.append(' ').append(opName).append(' ');
                        if (Objects.requireNonNull(arg2).getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text2).append(')');
                            break;
                        }
                        builder.append(text2);
                        break;
                    }
                    case YFX: {
                        if (arg1.getPrecedence() > functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                        } else {
                            builder.append(text1);
                        }
                        builder.append(' ').append(opName).append(' ');
                        if (Objects.requireNonNull(arg2).getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text2).append(')');
                            break;
                        }
                        builder.append(text2);
                        break;
                    }
                    case XFY: {
                        if (arg1.getPrecedence() >= functorPrecedence) {
                            builder.append('(').append(text1).append(')');
                        } else {
                            builder.append(text1);
                        }
                        builder.append(' ').append(opName).append(' ');
                        if (Objects.requireNonNull(arg2).getPrecedence() > functorPrecedence) {
                            builder.append('(').append(text2).append(')');
                            break;
                        }
                        builder.append(text2);
                        break;
                    }
                    default: {
                        throw new CriticalUnexpectedError();
                    }
                }
            }
        } else {
            String functorText = this.functor.getText();
            if ("!".equals(functorText) && this.getArity() == 0) {
                return functorText;
            }
            functorText = this.functor.toString();
            builder.append(functorText);
            builder.append('(');
            boolean next = false;
            for (PrologTerm term : this.elements) {
                if (next) {
                    builder.append(", ");
                } else {
                    next = true;
                }
                builder.append(term.toString());
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public Stream<PrologTerm> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.elements, 272), false);
    }

    @Override
    public Iterator<PrologTerm> iterator() {
        return new Iterator<PrologTerm>(){
            final PrologTerm[] terms;
            int index;
            {
                this.terms = (PrologTerm[])PrologStruct.this.elements.clone();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.terms.length;
            }

            @Override
            public PrologTerm next() {
                if (this.index < this.terms.length) {
                    return this.terms[this.index++];
                }
                throw new NoSuchElementException();
            }
        };
    }
}

