/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.terms.PrologCompound;
import com.igormaznitsa.prologparser.terms.PrologFloat;
import com.igormaznitsa.prologparser.terms.PrologInt;
import com.igormaznitsa.prologparser.terms.PrologNumeric;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class PrologTerm
implements Serializable,
Comparable<PrologTerm> {
    private static final long serialVersionUID = 1402429096900255841L;
    protected final Quotation quotation;
    protected final String text;
    private int line;
    private int pos;

    public PrologTerm(String text, Quotation quotation) {
        this.text = Objects.requireNonNull(text);
        this.pos = -1;
        this.line = -1;
        this.quotation = quotation == null ? Quotation.NONE : quotation;
    }

    public PrologTerm(String text, Quotation quotation, int line, int pos) {
        this(text, quotation);
        this.setLine(line);
        this.setPos(pos);
    }

    public static Quotation findQuotation(String atomText) {
        Quotation result = Quotation.NONE;
        if (atomText.length() == 0) {
            result = Quotation.SINGLE;
        } else {
            char chr = atomText.charAt(0);
            if (!Character.isLetter(chr) || Character.isDigit(chr) || Character.isUpperCase(chr) || Character.isISOControl(chr) || Character.isWhitespace(chr)) {
                result = Quotation.SINGLE;
            } else {
                for (int i = 1; i < atomText.length(); ++i) {
                    chr = atomText.charAt(i);
                    if (!Character.isWhitespace(chr) && (chr == '_' || Character.isLetterOrDigit(chr)) && !Character.isISOControl(chr)) continue;
                    result = Quotation.SINGLE;
                    break;
                }
            }
        }
        return result;
    }

    protected static String assertNonEmptyString(String str) {
        if (Objects.requireNonNull(str).isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty string");
        }
        return str;
    }

    public List<PrologTerm> flatComma(List<PrologTerm> list) {
        list.add(this);
        return list;
    }

    public int getArity() {
        return 1;
    }

    public boolean isAnyBlock() {
        return false;
    }

    public boolean isBlock() {
        return false;
    }

    public boolean isCurlyBlock() {
        return false;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public final int getPos() {
        return this.pos;
    }

    public final void setPos(int pos) {
        this.pos = pos <= 0 ? -1 : pos;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int line) {
        this.line = line <= 0 ? -1 : line;
    }

    public String getText() {
        return this.text;
    }

    public int getPrecedence() {
        return 0;
    }

    public String toString() {
        String result = this.quotation == Quotation.NONE ? this.text : this.quotation.quoteString(this.text);
        return result;
    }

    public abstract TermType getType();

    public Stream<PrologTerm> stream() {
        return Stream.of(this);
    }

    public PrologTerm getFunctor() {
        return this;
    }

    @Override
    public int compareTo(PrologTerm that) {
        int result;
        switch (this.getType()) {
            case VAR: {
                if (that.getType() == TermType.VAR) {
                    result = this.getText().compareTo(that.getText());
                    break;
                }
                result = -1;
                break;
            }
            case ATOM: {
                if (that.getType() == TermType.ATOM) {
                    if (this instanceof PrologNumeric) {
                        if (that instanceof PrologNumeric) {
                            if (this instanceof PrologInt) {
                                if (that instanceof PrologInt) {
                                    result = ((PrologInt)this).getIntValue().compareTo(((PrologInt)that).getIntValue());
                                    break;
                                }
                                result = new BigDecimal(((PrologInt)this).getIntValue()).compareTo(((PrologFloat)that).getFloatValue());
                                break;
                            }
                            if (that instanceof PrologInt) {
                                result = ((PrologFloat)this).getFloatValue().compareTo(new BigDecimal(((PrologInt)that).getIntValue()));
                                break;
                            }
                            result = ((PrologFloat)this).getFloatValue().compareTo(((PrologFloat)that).getFloatValue());
                            break;
                        }
                        result = -1;
                        break;
                    }
                    if (that instanceof PrologNumeric) {
                        result = 1;
                        break;
                    }
                    result = this.getText().compareTo(that.getText());
                    break;
                }
                if (that.getType() == TermType.VAR) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case LIST: 
            case STRUCT: {
                if (that instanceof PrologCompound) {
                    int leftResult = Integer.compare(this.getArity(), that.getArity());
                    if (leftResult == 0) {
                        leftResult = this.getText().compareTo(that.getText());
                    }
                    if (leftResult == 0) {
                        for (int i = 0; i < this.getArity() && (leftResult = ((PrologCompound)this).getTermAt(i).compareTo(((PrologCompound)that).getTermAt(i))) == 0; ++i) {
                        }
                    }
                    result = leftResult;
                    break;
                }
                result = 1;
                break;
            }
            default: {
                throw new CriticalUnexpectedError();
            }
        }
        return result;
    }
}

