/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.terms;

import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;

public final class PrologVar
extends PrologTerm {
    private static final long serialVersionUID = 1158349084517573220L;
    private final boolean anonymous;

    public PrologVar() {
        this("_");
    }

    public PrologVar(int line, int pos) {
        this();
        this.setPos(pos);
        this.setLine(line);
    }

    public PrologVar(String text) {
        super(text, Quotation.NONE);
        char startWith = PrologVar.assertNonEmptyString(text).charAt(0);
        if (!Character.isUpperCase(startWith) && startWith != '_') {
            throw new IllegalArgumentException("Var must start with upper case char or '_' [" + text + ']');
        }
        this.anonymous = text.length() == 1 && startWith == '_';
    }

    public PrologVar(String text, int line, int pos) {
        this(text);
        this.setPos(pos);
        this.setLine(line);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public TermType getType() {
        return TermType.VAR;
    }
}

