/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.tokenizer;

import com.igormaznitsa.prologparser.GenericPrologParser;
import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.terms.PrologStruct;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.terms.TermType;
import com.igormaznitsa.prologparser.tokenizer.OpAssoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Op
extends PrologTerm {
    public static final int PRECEDENCE_MAX = 0;
    public static final int PRECEDENCE_MIN = 1200;
    public static final Op GNU_UNARY_PLUS = Op.make(200, OpAssoc.FY, "+");
    public static final Op ISO_BITWISE_NEGATION = Op.make(200, OpAssoc.FY, "\\");
    public static final Op ISO_UNARY_MINUS = Op.make(200, OpAssoc.FY, "-");
    public static final Op ISO_UNIFICATION = Op.make(700, OpAssoc.XFX, "=", "\\=", "=..");
    public static final Op ISO_BITWISE_SHIFT = Op.make(400, OpAssoc.YFX, "<<", ">>");
    public static final Op ISO_ORDER_TERM = Op.make(700, OpAssoc.XFX, "==", "\\==", "@<", "@=<", "@>", "@>=");
    public static final Op ISO_ORDER_ARITH = Op.make(700, OpAssoc.XFX, "<", "=<", ">", ">=", "=:=", "=\\=", "is");
    public static final Op ISO_ARITH_PLUS_MINUS = Op.make(500, OpAssoc.YFX, "+", "-");
    public static final Op ISO_ARITH_MUL_DIV = Op.make(400, OpAssoc.YFX, "*", "/");
    public static final Op ISO_ARITH_POWER = Op.make(200, OpAssoc.XFX, "**");
    public static final Op ISO_ARITH_DIVIDE = Op.make(400, OpAssoc.YFX, "//", "mod", "rem");
    public static final Op ISO_NEGATE = Op.make(900, OpAssoc.FY, "\\+");
    public static final Op ISO_CLAUSES = Op.make(1200, OpAssoc.XFX, ":-", "-->");
    public static final Op ISO_DIRECTIVES = Op.make(1200, OpAssoc.FX, "?-", ":-");
    public static final Op ISO_BITWISE_AND_OR = Op.make(500, OpAssoc.YFX, "/\\", "\\/");
    public static final Op MODIFIERS = Op.make(1150, OpAssoc.FX, "public", "dynamic", "volatile", "discontiguous", "multifile", "initialization");
    public static final Op GNU_DIV_RDIV = Op.make(400, OpAssoc.YFX, "div", "rdiv");
    public static final Op ISO_OR = Op.make(1100, OpAssoc.XFY, ";");
    public static final Op ISO_THEN = Op.make(1050, OpAssoc.XFY, "->");
    public static final Op GNU_STAR_THEN = Op.make(1050, OpAssoc.XFY, "*->");
    public static final Op GNU_DOUBLE_DOT = Op.make(600, OpAssoc.XFY, ":");
    public static final List<Op> SICTUS_SPECIFIC = Collections.unmodifiableList(Arrays.asList(MODIFIERS, Op.make(1150, OpAssoc.FX, "mode", "block", "meta_predicate"), Op.make(1100, OpAssoc.XFY, "do"), Op.make(900, OpAssoc.FY, "spy", "nospy"), Op.make(550, OpAssoc.XFY, ":"), Op.make(500, OpAssoc.YFX, "\\"), GNU_UNARY_PLUS));
    public static final List<Op> ISO = Collections.unmodifiableList(Arrays.asList(ISO_CLAUSES, ISO_DIRECTIVES, ISO_OR, ISO_THEN, ISO_NEGATE, ISO_UNIFICATION, ISO_ORDER_ARITH, ISO_ORDER_TERM, ISO_ARITH_PLUS_MINUS, ISO_BITWISE_AND_OR, ISO_ARITH_MUL_DIV, ISO_BITWISE_SHIFT, ISO_ARITH_DIVIDE, ISO_ARITH_POWER, Op.make(200, OpAssoc.XFY, "^"), ISO_UNARY_MINUS, ISO_BITWISE_NEGATION, Op.make(100, OpAssoc.XFX, "@")));
    public static final List<Op> GNU_SPECIFIC = Collections.unmodifiableList(Arrays.asList(GNU_STAR_THEN, GNU_DOUBLE_DOT, GNU_DIV_RDIV, GNU_UNARY_PLUS));
    public static final List<Op> SWI_SPECIFIC = Collections.unmodifiableList(Arrays.asList(MODIFIERS, Op.make(1150, OpAssoc.FX, "meta_predicate", "module_transparent", "thread_local", "thread_initialization"), GNU_STAR_THEN, Op.make(990, OpAssoc.FY, ":="), Op.make(700, OpAssoc.XFX, "=@=", "\\=@=", "as", ">:<", ":<"), GNU_DOUBLE_DOT, Op.make(500, OpAssoc.YFX, "xor"), Op.make(500, OpAssoc.FX, "?"), GNU_DIV_RDIV, GNU_UNARY_PLUS, Op.make(1, OpAssoc.FX, "$")));
    public static final List<Op> SWI = Collections.unmodifiableList(Op.join(ISO, SWI_SPECIFIC));
    public static final List<Op> GNU_FD = Collections.unmodifiableList(Arrays.asList(Op.make(750, OpAssoc.XFY, "#<=>", "#\\<=>"), Op.make(740, OpAssoc.XFY, "#==>", "#\\==>"), Op.make(730, OpAssoc.XFY, "##"), Op.make(730, OpAssoc.YFX, "#\\/", "#\\\\/"), Op.make(720, OpAssoc.YFX, "#/\\", "#\\/\\"), Op.make(710, OpAssoc.FY, "#\\"), Op.make(700, OpAssoc.XFX, "#=", "#\\=", "#<", "#=<", "#>", "#>=", "#=#", "#\\=#", "#<#", "#=<#", "#>#", "#>=#")));
    public static final List<Op> GNU = Collections.unmodifiableList(Op.join(ISO, GNU_SPECIFIC));
    public static final List<Op> SWI_CPL = Collections.unmodifiableList(Arrays.asList(Op.make(300, OpAssoc.FY, "~"), Op.make(500, OpAssoc.YFX, "#"), Op.make(760, OpAssoc.YFX, "#<==>"), Op.make(750, OpAssoc.XFY, "#==>"), Op.make(750, OpAssoc.YFX, "#<=="), Op.make(740, OpAssoc.YFX, "#\\/"), Op.make(730, OpAssoc.YFX, "#\\"), Op.make(720, OpAssoc.YFX, "#/\\"), Op.make(710, OpAssoc.FY, "#\\"), Op.make(700, OpAssoc.XFX, "#>", "#<", "#>=", "#=<", "#=", "#\\=", "in", "ins"), Op.make(450, OpAssoc.XFX, "..")));
    public static final Op VIRTUAL_OPERATOR_BLOCK = Op.makeSystem(-1, OpAssoc.FX, "()");
    public static final Op VIRTUAL_OPERATOR_CURLY_BLOCK = Op.makeSystem(-1, OpAssoc.FX, "{}");
    public static final Op METAOPERATOR_COMMA = Op.makeSystem(1000, OpAssoc.XFY, ",");
    public static final Op METAOPERATOR_LEFT_BRACKET = Op.makeSystem(-1, OpAssoc.FX, "(");
    public static final Op METAOPERATOR_LEFT_CURLY_BRACKET = Op.makeSystem(-1, OpAssoc.FX, "{");
    public static final Op METAOPERATOR_RIGHT_BRACKET = Op.makeSystem(-1, OpAssoc.XF, ")");
    public static final Op METAOPERATOR_RIGHT_CURLY_BRACKET = Op.makeSystem(-1, OpAssoc.XF, "}");
    public static final Op METAOPERATOR_LEFT_SQUARE_BRACKET = Op.makeSystem(-1, OpAssoc.FX, "[");
    public static final Op METAOPERATOR_RIGHT_SQUARE_BRACKET = Op.makeSystem(-1, OpAssoc.XF, "]");
    public static final Op METAOPERATOR_DOT = Op.makeSystem(Integer.MAX_VALUE, OpAssoc.XF, ".");
    public static final Op METAOPERATOR_VERTICAL_BAR = Op.makeSystem(1105, OpAssoc.XFY, "|");
    private static final long serialVersionUID = -5914313127778138548L;
    private final OpAssoc opAssoc;
    private final int precedence;
    private final int preparedHash;
    private final String[] multiNames;

    private Op(int precedence, OpAssoc type, String name, String[] multiNames) {
        super(name, Quotation.NONE);
        Op.assertOpValidOpName(name);
        this.multiNames = multiNames;
        this.opAssoc = type;
        this.precedence = precedence;
        this.preparedHash = (name + '/' + this.opAssoc.name() + '/' + this.precedence).hashCode();
    }

    private static String[] assertOpValidOpName(String[] names) {
        Arrays.stream(names).forEach(Op::assertOpValidOpName);
        return names;
    }

    private static String assertOpValidOpName(String name) {
        char firstChar = Op.assertNonEmptyString(name).charAt(0);
        if (Character.isWhitespace(firstChar) || Character.isISOControl(firstChar)) {
            throw new IllegalArgumentException("Space char as first one");
        }
        if (Character.isUpperCase(firstChar)) {
            throw new IllegalArgumentException("Capital char as first one");
        }
        if (firstChar == '_') {
            throw new IllegalArgumentException("'_' can't be firs char");
        }
        return name;
    }

    public static Op make(int precedence, OpAssoc type, String ... names) {
        if (precedence < 0 || precedence > 1200) {
            throw new IllegalArgumentException("Precedence must be in 0..1200");
        }
        Objects.requireNonNull(type);
        Objects.requireNonNull(names);
        if (names.length == 0) {
            throw new IllegalArgumentException("Operator name must be defined");
        }
        return names.length == 1 ? new Op(precedence, type, Objects.requireNonNull(names[0]), null) : new Op(precedence, type, ".multi.", Op.assertOpValidOpName(names));
    }

    public static Op makeSystem(int precedence, OpAssoc type, String ... names) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(names);
        if (names.length == 0) {
            throw new IllegalArgumentException("Operator name must be defined");
        }
        return names.length == 1 ? new Op(precedence, type, Op.assertOpValidOpName(names[0]), null) : new Op(precedence, type, ".system.", Op.assertOpValidOpName(names));
    }

    @SafeVarargs
    public static List<Op> join(List<Op> ... args) {
        ArrayList<Op> result = new ArrayList<Op>();
        for (List<Op> l : args) {
            result.addAll(l);
        }
        return result;
    }

    public static Op[] add(Op[] args, Op ... ops) {
        int newLen = args.length + ops.length;
        Op[] result = Arrays.copyOf(args, newLen);
        int sourceIndex = 0;
        for (int i = args.length; i < newLen; ++i) {
            result[i] = ops[sourceIndex++];
        }
        return result;
    }

    public boolean isMultiName() {
        return this.multiNames != null;
    }

    public Stream<Op> streamOp() {
        if (this.multiNames == null) {
            return Stream.of(this);
        }
        return Stream.of(this.multiNames).map(x -> new Op(this.precedence, this.opAssoc, (String)x, null));
    }

    @Override
    public int getArity() {
        return this.opAssoc.getArity();
    }

    @Override
    public TermType getType() {
        return TermType.OPERATOR;
    }

    public OpAssoc getAssoc() {
        return this.opAssoc;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    public boolean isCompatibleWith(PrologStruct struct) {
        boolean result;
        if (struct != null) {
            block0 : switch (struct.getArity()) {
                case 1: {
                    switch (this.opAssoc) {
                        case XFY: 
                        case XFX: 
                        case YFX: {
                            result = false;
                            break block0;
                        }
                        case XF: 
                        case FX: {
                            PrologTerm atom = struct.getTermAt(0);
                            result = atom != null && atom.getPrecedence() < this.getPrecedence();
                            break block0;
                        }
                        case YF: 
                        case FY: {
                            PrologTerm atom = struct.getTermAt(0);
                            result = atom != null && atom.getPrecedence() <= this.getPrecedence();
                            break block0;
                        }
                    }
                    throw new CriticalUnexpectedError();
                }
                case 2: {
                    switch (this.opAssoc) {
                        case XFY: 
                        case XFX: 
                        case YFX: {
                            PrologTerm elementLeft = struct.getTermAt(0);
                            PrologTerm elementRight = struct.getTermAt(1);
                            if (elementLeft == null || elementRight == null) {
                                result = false;
                                break block0;
                            }
                            switch (this.opAssoc) {
                                case XFX: {
                                    result = elementLeft.getPrecedence() < this.getPrecedence() && elementRight.getPrecedence() < this.getPrecedence();
                                    break block0;
                                }
                                case YFX: {
                                    result = elementLeft.getPrecedence() <= this.getPrecedence() && elementRight.getPrecedence() < this.getPrecedence();
                                    break block0;
                                }
                                case XFY: {
                                    result = elementLeft.getPrecedence() < this.getPrecedence() && elementRight.getPrecedence() <= this.getPrecedence();
                                    break block0;
                                }
                            }
                            result = false;
                            break block0;
                        }
                        case XF: 
                        case FX: {
                            PrologTerm atom = struct.getTermAt(this.opAssoc == OpAssoc.XF ? 0 : 1);
                            result = atom != null && atom.getPrecedence() < this.getPrecedence();
                            break block0;
                        }
                        case YF: 
                        case FY: {
                            PrologTerm atom = struct.getTermAt(this.opAssoc == OpAssoc.YF ? 0 : 1);
                            result = atom != null && atom.getPrecedence() <= this.getPrecedence();
                            break block0;
                        }
                    }
                    throw new CriticalUnexpectedError();
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.preparedHash;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof Op) {
            Op op = (Op)obj;
            if (this.preparedHash == op.preparedHash && this.precedence == op.precedence && this.opAssoc == op.opAssoc && this.text.equals(op.text)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.isMultiName()) {
            return String.format("op(%d, %s, [%s]).", this.getPrecedence(), this.getAssoc().toString().toLowerCase(Locale.ENGLISH), Stream.of(this.multiNames).map(x -> '\'' + x + '\'').collect(Collectors.joining(",")));
        }
        return String.format("op(%d, %s, '%s').", this.getPrecedence(), this.getAssoc().toString().toLowerCase(Locale.ENGLISH), this.getText());
    }

    private Object readResolve() {
        Op result = GenericPrologParser.findBaseMetaOperator(this.text, this.opAssoc);
        return result == null ? this : result;
    }
}

