/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.tokenizer;

import java.util.Optional;
import java.util.stream.Stream;

public enum OpAssoc {
    XF("xf", 1),
    YF("yf", 1),
    FX("fx", 1),
    FY("fy", 1),
    XFX("xfx", 2),
    XFY("xfy", 2),
    YFX("yfx", 2);

    private final String text;
    private final int arity;

    private OpAssoc(String text, int arity) {
        this.text = text;
        this.arity = arity;
    }

    public static Optional<OpAssoc> findForName(String str) {
        return Stream.of(OpAssoc.values()).filter(x -> x.text.equals(str)).findFirst();
    }

    public boolean isPostfix() {
        return this == XF || this == YF;
    }

    public boolean isPrefix() {
        return this == FX || this == FY;
    }

    public int getArity() {
        return this.arity;
    }

    public String getText() {
        return this.text;
    }
}

