/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.tokenizer;

import com.igormaznitsa.prologparser.ParserContext;
import com.igormaznitsa.prologparser.PrologParser;
import com.igormaznitsa.prologparser.exceptions.CriticalUnexpectedError;
import com.igormaznitsa.prologparser.exceptions.PrologParserException;
import com.igormaznitsa.prologparser.terms.OpContainer;
import com.igormaznitsa.prologparser.terms.PrologAtom;
import com.igormaznitsa.prologparser.terms.PrologFloat;
import com.igormaznitsa.prologparser.terms.PrologInt;
import com.igormaznitsa.prologparser.terms.PrologTerm;
import com.igormaznitsa.prologparser.terms.PrologVar;
import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.tokenizer.TokenizerResult;
import com.igormaznitsa.prologparser.tokenizer.TokenizerState;
import com.igormaznitsa.prologparser.utils.Koi7CharOpMap;
import com.igormaznitsa.prologparser.utils.StringBuilderEx;
import com.igormaznitsa.prologparser.utils.StringUtils;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigInteger;

public final class Tokenizer {
    private final StringBuilderEx strBuf;
    private final StringBuilderEx specCharBuf;
    private final StringBuilderEx insideCharBuffer;
    private final boolean blockCommentsAllowed;
    private final boolean zeroSingleQuotationAllowed;
    private final boolean zeroQuotationAllowsWhitespaceChar;
    private final Reader reader;
    private final PrologParser parser;
    private final Koi7CharOpMap metaOperators;
    private TokenizerResult lastPushedTerm;
    private int prevTokenLine;
    private int prevTokenPos;
    private int lastTokenLine;
    private int lastTokenPos;
    private int prevPos;
    private int prevLine;
    private int pos;
    private int line;

    public Tokenizer(PrologParser parser, Koi7CharOpMap metaOperators, Reader reader) {
        this.metaOperators = metaOperators;
        this.reader = reader;
        this.parser = parser;
        int maxAllowedCharBufferSize = parser.getContext() == null ? Integer.MAX_VALUE : parser.getContext().getMaxTokenizerBufferLength();
        this.blockCommentsAllowed = parser.getContext() != null && (parser.getContext().getFlags() & 1) != 0;
        this.zeroSingleQuotationAllowed = parser.getContext() != null && (parser.getContext().getFlags() & 2) != 0;
        this.zeroQuotationAllowsWhitespaceChar = parser.getContext() != null && (parser.getContext().getFlags() & 0x40) != 0;
        this.strBuf = new StringBuilderEx(32, maxAllowedCharBufferSize);
        this.specCharBuf = new StringBuilderEx(8, maxAllowedCharBufferSize);
        this.insideCharBuffer = new StringBuilderEx(8, maxAllowedCharBufferSize);
        this.pos = 1;
        this.line = 1;
        this.prevPos = 1;
        this.prevLine = 1;
    }

    public static boolean isCharAllowedForRadix(char chr, int radix) {
        if (radix == 10) {
            return Character.isDigit(chr);
        }
        if (radix < 10) {
            return chr >= '0' && chr < 48 + radix;
        }
        if (chr >= '0' && chr <= '9') {
            return true;
        }
        int diff = radix - 10;
        if (chr >= 'A' && chr < 65 + diff) {
            return true;
        }
        return chr >= 'a' && chr < 97 + diff;
    }

    TokenizerResult getLastPushed() {
        return this.lastPushedTerm;
    }

    private synchronized int doReadChar() throws IOException {
        int ch = this.insideCharBuffer.isEmpty() ? this.reader.read() : (int)this.insideCharBuffer.pop();
        this.prevPos = this.pos++;
        this.prevLine = this.line++;
        if (ch == 10) {
            this.pos = 1;
        } else if (ch >= 0) {
            // empty if block
        }
        return ch;
    }

    public void calcDiffAndPushResultBack(String etalon, StringBuilderEx buffer) {
        int bufferPosition = buffer.length() - 1;
        int locPos = this.pos;
        int locPosPrev = this.prevPos;
        int locLine = this.line;
        int locLinePrev = this.prevLine;
        for (int chars = buffer.length() - etalon.length(); chars > 0; --chars) {
            char ch = buffer.charAt(bufferPosition--);
            this.insideCharBuffer.push(ch);
            locPosPrev = locPos = Math.max(1, locPos - 1);
            if (ch != '\n') continue;
            locLinePrev = locLine = Math.max(1, locLine - 1);
        }
        this.pos = locPos;
        this.prevPos = locPosPrev;
        this.line = locLine;
        this.prevLine = locLinePrev;
    }

    public void push(char ch) {
        this.insideCharBuffer.push(ch);
        if (ch == '\n') {
            this.pos = 1;
            this.line = Math.max(1, this.line - 1);
        } else {
            this.pos = Math.max(1, this.pos - 1);
        }
    }

    public void close(boolean closeReader) throws IOException {
        this.lastPushedTerm = null;
        try {
            if (this.reader instanceof PushbackReader) {
                PushbackReader pbReader = (PushbackReader)this.reader;
                while (!this.strBuf.isEmpty()) {
                    pbReader.unread(this.strBuf.pop());
                }
            }
        }
        finally {
            this.strBuf.clear();
            if (closeReader) {
                this.reader.close();
            }
        }
    }

    public boolean hasOperatorStartsWith(String operatorNameStartSubstring) {
        ParserContext ctx;
        boolean result = false;
        if (this.metaOperators.contains(operatorNameStartSubstring)) {
            result = true;
        } else if (this.parser != null && (ctx = this.parser.getContext()) != null) {
            result = ctx.hasOpStartsWith(this.parser, operatorNameStartSubstring);
        }
        return result;
    }

    public OpContainer findOperatorForName(String operatorName) {
        ParserContext ctx;
        OpContainer result = null;
        if (operatorName.length() == 1) {
            result = this.metaOperators.get(operatorName);
        }
        if (result == null && (ctx = this.parser.getContext()) != null) {
            result = ctx.findOpForName(this.parser, operatorName);
        }
        return result;
    }

    public OpContainer findOperatorForSingleChar(char c) {
        OpContainer result = this.metaOperators.get(c);
        if (result == null) {
            return this.findOperatorForName(String.valueOf(c));
        }
        return result;
    }

    public void push(TokenizerResult object) {
        if (this.lastPushedTerm != null) {
            throw new IllegalStateException("There is already pushed term");
        }
        this.lastPushedTerm = object;
    }

    public TokenizerResult peek() {
        TokenizerResult result;
        if (this.lastPushedTerm == null) {
            result = this.readNextToken();
            this.push(result);
        } else {
            result = this.lastPushedTerm;
        }
        return result;
    }

    public int getLastTokenPos() {
        return this.lastPushedTerm == null ? this.lastTokenPos : this.prevTokenPos;
    }

    public int getLastTokenLine() {
        return this.lastPushedTerm == null ? this.lastTokenLine : this.prevTokenLine;
    }

    public void fixPosition() {
        this.prevTokenLine = this.lastTokenLine;
        this.prevTokenPos = this.lastTokenPos;
        this.lastTokenLine = this.line;
        this.lastTokenPos = this.pos - 1;
    }

    private void skipUntilBlockCommentEnd() throws IOException {
        int readChar;
        boolean starCharDetected = false;
        while (!(Thread.currentThread().isInterrupted() || (readChar = this.doReadChar()) < 0 || readChar == 47 && starCharDetected)) {
            starCharDetected = readChar == 42;
        }
    }

    private void skipUntilNextString() throws IOException {
        int readChar;
        while (!Thread.currentThread().isInterrupted() && (readChar = this.doReadChar()) >= 0 && readChar != 10) {
        }
    }

    public TokenizerResult pop() {
        try {
            TokenizerResult tokenizerResult = this.lastPushedTerm;
            return tokenizerResult;
        }
        finally {
            this.lastPushedTerm = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenizerResult readNextToken() {
        if (this.lastPushedTerm != null) {
            return this.pop();
        }
        Quotation quoting = Quotation.NONE;
        int radix = 10;
        char detectedRadixChar = ' ';
        TokenizerState state = TokenizerState.LOOK_FOR;
        boolean specCharDetected = false;
        boolean charCodeAsInt = false;
        this.strBuf.clear();
        this.specCharBuf.clear();
        StringBuilderEx strBuffer = this.strBuf;
        StringBuilderEx specCharBuffer = this.specCharBuf;
        PrologTerm lastFoundFullOperator = null;
        boolean letterOrDigitOnly = false;
        boolean foundUnderscoreInNumber = false;
        try {
            block31: while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                int readChar = this.doReadChar();
                if (readChar < 0) {
                    switch (state) {
                        case LOOK_FOR: {
                            return null;
                        }
                        case FLOAT: 
                        case INTEGER: 
                        case ATOM: {
                            if (foundUnderscoreInNumber) {
                                throw new PrologParserException("Contains unexpected underscore: " + strBuffer.toString(), this.prevLine, this.prevPos);
                            }
                            if (state == TokenizerState.FLOAT && strBuffer.isLastChar('.')) {
                                this.push('.');
                                return new TokenizerResult(this.makeTermFromString(strBuffer.toStringExcludeLastChar(), radix, quoting, TokenizerState.INTEGER), TokenizerState.INTEGER, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            String text = strBuffer.toString();
                            return new TokenizerResult(this.makeTermFromString(text, radix, PrologTerm.findQuotation(text), state), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        case VAR: {
                            if (strBuffer.isSingleChar('_')) {
                                return new TokenizerResult(new PrologVar(), state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            return new TokenizerResult(new PrologVar(strBuffer.toString()), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        case STRING: {
                            throw new PrologParserException("Non-completed string: " + strBuffer.toString(), this.lastTokenLine, this.lastTokenPos);
                        }
                        case OPERATOR: {
                            if (lastFoundFullOperator == null) {
                                return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            this.calcDiffAndPushResultBack(lastFoundFullOperator.getText(), strBuffer);
                            return new TokenizerResult(lastFoundFullOperator, state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                    }
                    throw new PrologParserException("Non-completed term (" + (Object)((Object)state) + "): " + strBuffer.toString(), this.prevLine, this.prevPos);
                }
                char chr = (char)readChar;
                if (state != TokenizerState.STRING && this.blockCommentsAllowed && chr == '*' && this.strBuf.isLastChar('/')) {
                    if (this.strBuf.isSingleChar('/')) {
                        this.strBuf.pop();
                        state = this.strBuf.isEmpty() ? TokenizerState.LOOK_FOR : state;
                    } else if (state == TokenizerState.OPERATOR) {
                        throw new PrologParserException("Operator can be mixed with comment block: " + this.strBuf.toString() + chr, this.getLastTokenLine(), this.getLastTokenPos());
                    }
                    this.skipUntilBlockCommentEnd();
                    continue;
                }
                switch (state) {
                    case LOOK_FOR: {
                        if (Character.isWhitespace(chr) || Character.isISOControl(chr)) continue block31;
                        switch (chr) {
                            case '%': {
                                this.skipUntilNextString();
                                continue block31;
                            }
                            case '_': {
                                this.fixPosition();
                                strBuffer.append(chr);
                                state = TokenizerState.VAR;
                                continue block31;
                            }
                            case '\'': {
                                this.fixPosition();
                                quoting = Quotation.SINGLE;
                                state = TokenizerState.STRING;
                                continue block31;
                            }
                            case '\"': {
                                this.fixPosition();
                                quoting = Quotation.DOUBLE;
                                state = TokenizerState.STRING;
                                continue block31;
                            }
                            case '`': {
                                this.fixPosition();
                                quoting = Quotation.BACK_TICK;
                                state = TokenizerState.STRING;
                                continue block31;
                            }
                        }
                        this.fixPosition();
                        strBuffer.append(chr);
                        if (Character.isUpperCase(chr)) {
                            state = TokenizerState.VAR;
                            continue block31;
                        }
                        letterOrDigitOnly = Character.isLetterOrDigit(chr);
                        String operator = String.valueOf(chr);
                        if (this.hasOperatorStartsWith(operator)) {
                            lastFoundFullOperator = this.findOperatorForName(operator);
                            state = TokenizerState.OPERATOR;
                            continue block31;
                        }
                        if (Character.isDigit(chr)) {
                            state = TokenizerState.INTEGER;
                            continue block31;
                        }
                        state = TokenizerState.ATOM;
                        continue block31;
                    }
                    case ATOM: {
                        Object operator;
                        if (chr == '_') {
                            strBuffer.append(chr);
                            continue block31;
                        }
                        if (Character.isISOControl(chr) || Character.isWhitespace(chr)) {
                            String text = strBuffer.toString();
                            if (quoting == Quotation.NONE && (operator = this.findOperatorForName(text)) != null) {
                                return new TokenizerResult((PrologTerm)operator, TokenizerState.OPERATOR, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            return new TokenizerResult(this.makeTermFromString(text, radix, PrologTerm.findQuotation(text), state), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        if (chr == '\'' || chr == '\"' || chr == '`' || letterOrDigitOnly != Character.isLetterOrDigit(chr) || !Character.isLetter(chr) && this.findOperatorForSingleChar(chr) != null) {
                            this.push(chr);
                            String text = strBuffer.toString();
                            if (quoting == Quotation.NONE && (operator = this.findOperatorForName(text)) != null) {
                                return new TokenizerResult((PrologTerm)operator, TokenizerState.OPERATOR, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            return new TokenizerResult(this.makeTermFromString(text, radix, PrologTerm.findQuotation(text), state), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        strBuffer.append(chr);
                        continue block31;
                    }
                    case INTEGER: {
                        if (Tokenizer.isCharAllowedForRadix(chr, radix)) {
                            foundUnderscoreInNumber = false;
                            strBuffer.append(chr);
                            continue block31;
                        }
                        if (chr == '_') {
                            if (foundUnderscoreInNumber) {
                                throw new PrologParserException("Duplicated underscore char in integer", this.prevLine, this.prevPos);
                            }
                            foundUnderscoreInNumber = true;
                            continue block31;
                        }
                        if (chr == '.' || chr == 'e' || chr == 'E') {
                            if (foundUnderscoreInNumber) {
                                throw new PrologParserException("Underscore is not allowed before E or dot", this.prevLine, this.prevPos);
                            }
                            strBuffer.append(chr);
                            state = TokenizerState.FLOAT;
                            continue block31;
                        }
                        if (foundUnderscoreInNumber) {
                            throw new PrologParserException("Unexpected underscore", this.prevLine, this.prevPos);
                        }
                        if (chr == '\'') {
                            if (strBuffer.isSingleChar('0')) {
                                if (!this.zeroSingleQuotationAllowed) {
                                    this.push(chr);
                                    return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), TokenizerState.INTEGER, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                state = TokenizerState.STRING;
                                charCodeAsInt = true;
                                strBuffer.clear();
                                continue block31;
                            }
                            radix = Integer.parseInt(strBuffer.toString());
                            if (radix < 2 || radix > 36) {
                                throw new PrologParserException("Radix must be 2..36: " + radix, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            strBuffer.clear();
                            continue block31;
                        }
                        boolean radixCharFound = false;
                        if (radix == 10 && strBuffer.isSingleChar('0')) {
                            if (chr == 'x') {
                                radixCharFound = true;
                                radix = 16;
                                detectedRadixChar = chr;
                                strBuffer.clear();
                            } else if (chr == 'o') {
                                radixCharFound = true;
                                radix = 8;
                                detectedRadixChar = chr;
                                strBuffer.clear();
                            } else if (chr == 'b') {
                                radixCharFound = true;
                                radix = 2;
                                detectedRadixChar = chr;
                                strBuffer.clear();
                            }
                        }
                        if (radixCharFound) continue block31;
                        this.push(chr);
                        if (strBuffer.isEmpty() && detectedRadixChar != ' ') {
                            this.push(detectedRadixChar);
                            strBuffer.append('0');
                        }
                        return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), TokenizerState.INTEGER, this.getLastTokenLine(), this.getLastTokenPos());
                    }
                    case FLOAT: {
                        if (Character.isDigit(chr)) {
                            foundUnderscoreInNumber = false;
                            strBuffer.append(chr);
                            continue block31;
                        }
                        if (chr == '_') {
                            if (foundUnderscoreInNumber || strBuffer.isLastChar('.')) {
                                throw new PrologParserException("Underscore after dot in number: " + strBuffer.toString(), this.prevLine, this.prevPos);
                            }
                            foundUnderscoreInNumber = true;
                            continue block31;
                        }
                        if (chr == '-' || chr == '+') {
                            if (!strBuffer.isLastChar('e')) {
                                this.push(chr);
                                return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, TokenizerState.FLOAT), TokenizerState.FLOAT, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            strBuffer.append(chr);
                            continue block31;
                        }
                        if (chr == 'e' || chr == 'E') {
                            if (foundUnderscoreInNumber) {
                                throw new PrologParserException("Underscore is not allowed before E", this.prevLine, this.prevPos);
                            }
                            if (strBuffer.lastIndexOf('e') >= 0) {
                                this.push(chr);
                                return new TokenizerResult(this.makeTermFromString(strBuffer.toStringExcludeLastChar(), radix, quoting, TokenizerState.FLOAT), TokenizerState.FLOAT, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            strBuffer.append('e');
                            continue block31;
                        }
                        this.push(chr);
                        if (foundUnderscoreInNumber) {
                            throw new PrologParserException("Unexpected underscore", this.prevLine, this.prevPos);
                        }
                        if (strBuffer.isLastChar('.')) {
                            this.push('.');
                            return new TokenizerResult(this.makeTermFromString(strBuffer.toStringExcludeLastChar(), radix, quoting, TokenizerState.INTEGER), TokenizerState.INTEGER, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        if (!Character.isDigit(strBuffer.getLastChar())) {
                            throw new PrologParserException("Unexpected end of float: " + strBuffer.toString(), this.prevLine, this.prevPos);
                        }
                        return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                    }
                    case OPERATOR: {
                        if (chr != '_' && letterOrDigitOnly != Character.isLetterOrDigit(chr)) {
                            this.push(chr);
                            if (lastFoundFullOperator != null && !letterOrDigitOnly) {
                                this.calcDiffAndPushResultBack(lastFoundFullOperator.getText(), strBuffer);
                                return new TokenizerResult(lastFoundFullOperator, state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            String textInBuffer = strBuffer.toString();
                            if (lastFoundFullOperator != null && lastFoundFullOperator.getText().equals(textInBuffer)) {
                                return new TokenizerResult(lastFoundFullOperator, state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            return new TokenizerResult(this.makeTermFromString(textInBuffer, radix, quoting, TokenizerState.ATOM), TokenizerState.ATOM, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        PrologTerm previouslyDetectedOperator = lastFoundFullOperator;
                        strBuffer.append(chr);
                        Object operator = strBuffer.toString();
                        lastFoundFullOperator = this.findOperatorForName((String)operator);
                        if (previouslyDetectedOperator == null) {
                            if (this.hasOperatorStartsWith((String)operator)) continue block31;
                            if (this.hasOperatorStartsWith(String.valueOf(chr))) {
                                strBuffer.pop();
                                this.push(chr);
                            }
                            state = TokenizerState.ATOM;
                            continue block31;
                        }
                        if (lastFoundFullOperator == null) {
                            if (this.hasOperatorStartsWith((String)operator)) {
                                lastFoundFullOperator = previouslyDetectedOperator;
                                continue block31;
                            }
                            if (!letterOrDigitOnly) {
                                this.calcDiffAndPushResultBack(previouslyDetectedOperator.getText(), strBuffer);
                                return new TokenizerResult(previouslyDetectedOperator, state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            state = TokenizerState.ATOM;
                            continue block31;
                        }
                        if (this.hasOperatorStartsWith((String)operator)) continue block31;
                        this.calcDiffAndPushResultBack(previouslyDetectedOperator.getText(), strBuffer);
                        return new TokenizerResult(previouslyDetectedOperator, state, this.getLastTokenLine(), this.getLastTokenPos());
                    }
                    case STRING: {
                        if (specCharDetected) {
                            if (specCharBuffer.isEmpty() && chr == '\n') {
                                specCharDetected = false;
                                strBuffer.append('\n');
                                if (!charCodeAsInt) continue block31;
                                return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            if (!Character.isISOControl(chr)) {
                                specCharBuffer.append(chr);
                                StringUtils.UnescapeResult result = StringUtils.tryUnescapeCharacter(specCharBuffer);
                                if (result.isError()) {
                                    throw new PrologParserException("Detected wrong escape char: \\" + specCharBuffer.toString(), this.prevLine, this.prevPos);
                                }
                                if (result.doesNeedMore()) continue block31;
                                specCharDetected = false;
                                if (charCodeAsInt) {
                                    return new TokenizerResult(new PrologInt(result.getDecoded()), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                strBuffer.append(result.getDecoded());
                                continue block31;
                            }
                            if (chr == '\r' && specCharBuffer.isEmpty()) continue block31;
                            throw new PrologParserException("Unexpected char: 0x" + Integer.toHexString(chr), this.prevLine, this.prevPos);
                        }
                        switch (chr) {
                            case '\'': {
                                if (quoting == Quotation.SINGLE) {
                                    return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                if (charCodeAsInt) {
                                    throw new PrologParserException("Char ''' must be escaped in such case", this.prevLine, this.prevPos);
                                }
                                strBuffer.append(chr);
                                continue block31;
                            }
                            case '`': {
                                if (quoting == Quotation.BACK_TICK) {
                                    return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                if (charCodeAsInt) {
                                    return new TokenizerResult(new PrologInt(chr), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                strBuffer.append(chr);
                                continue block31;
                            }
                            case '\"': {
                                if (quoting == Quotation.DOUBLE) {
                                    return new TokenizerResult(this.makeTermFromString(strBuffer.toString(), radix, quoting, state), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                if (charCodeAsInt) {
                                    return new TokenizerResult(new PrologInt(chr), state, this.getLastTokenLine(), this.getLastTokenPos());
                                }
                                strBuffer.append(chr);
                                continue block31;
                            }
                            case '\\': {
                                specCharDetected = true;
                                specCharBuffer.clear();
                                continue block31;
                            }
                        }
                        if (Character.isISOControl(chr)) {
                            throw new PrologParserException("Unexpected control char: 0x" + Integer.toHexString(chr), this.prevLine, this.prevPos);
                        }
                        char theChar = chr;
                        if (charCodeAsInt) {
                            if (Character.isWhitespace(chr) && !this.zeroQuotationAllowsWhitespaceChar) {
                                throw new PrologParserException("Unexpected whitespace char: 0x" + Integer.toHexString(chr), this.prevLine, this.prevPos);
                            }
                            return new TokenizerResult(new PrologInt(theChar), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        strBuffer.append(theChar);
                        continue block31;
                    }
                    case VAR: {
                        if (!StringUtils.isCharAllowedForUnquotedAtom(chr)) {
                            this.push(chr);
                            if (strBuffer.isSingleChar('_')) {
                                return new TokenizerResult(new PrologVar(), state, this.getLastTokenLine(), this.getLastTokenPos());
                            }
                            return new TokenizerResult(new PrologVar(strBuffer.toString()), state, this.getLastTokenLine(), this.getLastTokenPos());
                        }
                        strBuffer.append(chr);
                        continue block31;
                    }
                }
                throw new CriticalUnexpectedError();
            }
        }
        catch (IOException ex) {
            throw new PrologParserException("IO exception during read char", this.prevLine, this.prevPos, ex);
        }
    }

    public PrologTerm makeTermFromString(String str, int radix, Quotation quotingType, TokenizerState state) {
        PrologTerm result;
        switch (state) {
            case INTEGER: {
                try {
                    result = radix == 10 ? new PrologInt(str) : new PrologInt(new BigInteger(str, radix));
                }
                catch (NumberFormatException ex) {
                    result = null;
                }
                break;
            }
            case FLOAT: {
                try {
                    result = new PrologFloat(str);
                }
                catch (NumberFormatException ex) {
                    result = null;
                }
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            result = new PrologAtom(str, quotingType);
        }
        return result;
    }

    public int getLine() {
        return this.line;
    }

    public int getPos() {
        return this.pos;
    }
}

