/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.utils;

import com.igormaznitsa.prologparser.terms.OpContainer;
import com.igormaznitsa.prologparser.tokenizer.Op;
import java.util.Arrays;

public final class Koi7CharOpMap {
    private final OpContainer[] charMap;

    private Koi7CharOpMap(OpContainer ... containers) {
        this.charMap = new OpContainer[128];
        Arrays.stream(containers).forEach(x -> this.put(x.getText(), (OpContainer)x));
    }

    private Koi7CharOpMap(Koi7CharOpMap source) {
        this.charMap = (OpContainer[])source.charMap.clone();
    }

    public static Koi7CharOpMap copyOf(Koi7CharOpMap source) {
        return new Koi7CharOpMap(source);
    }

    public static Koi7CharOpMap ofOps(OpContainer ... containers) {
        return new Koi7CharOpMap(containers);
    }

    public OpContainer add(Op operator) {
        String text = operator.getText();
        if (text.length() != 1) {
            throw new IllegalArgumentException("Must be single char: " + text);
        }
        OpContainer container = this.get(text);
        if (container == null) {
            container = OpContainer.make(operator);
            this.put(text, container);
        }
        container.add(operator);
        return container;
    }

    public boolean contains(String key) {
        if (key.length() != 1) {
            return false;
        }
        char chr = key.charAt(0);
        return chr < '\u0080' && this.charMap[chr] != null;
    }

    public void put(String key, OpContainer container) {
        if (key.length() != 1) {
            throw new IllegalArgumentException("Illegal key, must be single char: " + key);
        }
        char chr = key.charAt(0);
        if (chr > '\u007f') {
            throw new IllegalArgumentException("Illegal char code, must be <128: " + chr);
        }
        this.charMap[chr] = container;
    }

    public OpContainer get(String key) {
        if (key.length() != 1) {
            return null;
        }
        char code = key.charAt(0);
        OpContainer result = code < '\u0080' ? this.charMap[code] : null;
        return result;
    }

    public OpContainer get(char c) {
        return c > '\u007f' ? null : this.charMap[c];
    }
}

