/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.utils;

import com.igormaznitsa.prologparser.exceptions.CharBufferOverflowException;

public final class StringBuilderEx {
    private final int limit;
    private final StringBuilder stringBuilder;

    public StringBuilderEx(String initialString) {
        this(initialString, Integer.MAX_VALUE);
    }

    public StringBuilderEx(int capacity) {
        this(capacity, Integer.MAX_VALUE);
    }

    public StringBuilderEx(String initialString, int limit) {
        this.stringBuilder = new StringBuilder(initialString);
        this.limit = this.assertLimitValue(limit);
        this.assertBufferLimit();
    }

    public StringBuilderEx(int capacity, int limit) {
        this.stringBuilder = new StringBuilder(capacity);
        this.limit = this.assertLimitValue(limit);
    }

    public StringBuilderEx append(char chr) {
        this.stringBuilder.append(chr);
        this.assertBufferLimit();
        return this;
    }

    public int length() {
        return this.stringBuilder.length();
    }

    public char charAt(int position) {
        return this.stringBuilder.charAt(position);
    }

    private int assertLimitValue(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive: " + limit);
        }
        return limit;
    }

    public int lastIndexOf(char chr) {
        for (int i = this.stringBuilder.length() - 1; i >= 0; --i) {
            if (this.stringBuilder.charAt(i) != chr) continue;
            return i;
        }
        return -1;
    }

    public boolean isSingleChar(char chr) {
        return this.stringBuilder.length() == 1 && this.stringBuilder.charAt(0) == chr;
    }

    public boolean isLastChar(char chr) {
        int length = this.stringBuilder.length();
        return length > 0 && this.stringBuilder.charAt(length - 1) == chr;
    }

    public String toStringExcludeLastChar() {
        return this.stringBuilder.substring(0, this.stringBuilder.length() - 1);
    }

    public boolean hasSeveralChars() {
        return this.stringBuilder.length() > 1;
    }

    public char getLastChar() {
        return this.stringBuilder.charAt(this.stringBuilder.length() - 1);
    }

    public String substring(int start) {
        return this.stringBuilder.substring(start);
    }

    public String substring(int start, int end) {
        return this.stringBuilder.substring(start, end);
    }

    public StringBuilderEx append(String str) {
        this.stringBuilder.append(str);
        this.assertBufferLimit();
        return this;
    }

    public void clear() {
        this.stringBuilder.setLength(0);
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void assertBufferLimit() {
        if (this.stringBuilder.length() > this.limit) {
            throw new CharBufferOverflowException(this.stringBuilder.toString());
        }
    }

    public void push(char chr) {
        this.stringBuilder.append(chr);
        this.assertBufferLimit();
    }

    public char pop() {
        char chr = this.stringBuilder.charAt(this.stringBuilder.length() - 1);
        this.stringBuilder.setLength(this.stringBuilder.length() - 1);
        return chr;
    }

    public boolean isEmpty() {
        return this.stringBuilder.length() == 0;
    }

    public boolean isFirstCharDigit() {
        return this.stringBuilder.length() > 0 && Character.isDigit(this.stringBuilder.charAt(0));
    }
}

