/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.prologparser.utils;

import com.igormaznitsa.prologparser.terms.Quotation;
import com.igormaznitsa.prologparser.utils.StringBuilderEx;

public final class StringUtils {
    private StringUtils() {
    }

    public static UnescapeResult tryUnescapeCharacter(StringBuilderEx stringAfterEscMarker) {
        if (stringAfterEscMarker == null || stringAfterEscMarker.isEmpty()) {
            return new UnescapeResult('_', false, true);
        }
        int len = stringAfterEscMarker.length();
        if (len == 1) {
            char result;
            switch (stringAfterEscMarker.charAt(0)) {
                case 'a': {
                    result = '\u0007';
                    break;
                }
                case 'b': {
                    result = '\b';
                    break;
                }
                case 'n': {
                    result = '\n';
                    break;
                }
                case 'f': {
                    result = '\f';
                    break;
                }
                case 'r': {
                    result = '\r';
                    break;
                }
                case 'e': {
                    result = '\u001b';
                    break;
                }
                case 't': {
                    result = '\t';
                    break;
                }
                case 's': {
                    result = ' ';
                    break;
                }
                case 'v': {
                    result = '\u000b';
                    break;
                }
                case '\\': {
                    result = '\\';
                    break;
                }
                case '\'': {
                    result = '\'';
                    break;
                }
                case '\"': {
                    result = '\"';
                    break;
                }
                case '`': {
                    result = '`';
                    break;
                }
                case 'u': 
                case 'x': {
                    return new UnescapeResult(stringAfterEscMarker.charAt(0), true, false);
                }
                default: {
                    if (stringAfterEscMarker.isFirstCharDigit() && stringAfterEscMarker.charAt(0) < '8') {
                        return new UnescapeResult(stringAfterEscMarker.charAt(0), true, false);
                    }
                    return new UnescapeResult(stringAfterEscMarker.charAt(0), false, true);
                }
            }
            return new UnescapeResult(result, false, false);
        }
        switch (stringAfterEscMarker.charAt(0)) {
            case 'u': {
                if (len == 5) {
                    int decoded;
                    try {
                        decoded = Integer.parseInt(stringAfterEscMarker.substring(1), 16);
                    }
                    catch (NumberFormatException ex) {
                        return new UnescapeResult('u', false, true);
                    }
                    return new UnescapeResult((char)decoded, false, false);
                }
                if (len > 5) {
                    return new UnescapeResult('u', false, true);
                }
                if (stringAfterEscMarker.hasSeveralChars() && StringUtils.isCharNotAppropriateForHexNum(stringAfterEscMarker.getLastChar())) {
                    return new UnescapeResult('u', false, true);
                }
                return new UnescapeResult('u', true, false);
            }
            case 'x': {
                if (stringAfterEscMarker.isLastChar('\\')) {
                    int decoded;
                    try {
                        decoded = Integer.parseInt(stringAfterEscMarker.substring(1, stringAfterEscMarker.length() - 1), 16);
                    }
                    catch (NumberFormatException ex) {
                        return new UnescapeResult('x', false, true);
                    }
                    return new UnescapeResult((char)decoded, false, false);
                }
                if (stringAfterEscMarker.hasSeveralChars() && StringUtils.isCharNotAppropriateForHexNum(stringAfterEscMarker.getLastChar())) {
                    return new UnescapeResult('x', false, true);
                }
                return new UnescapeResult('x', true, false);
            }
        }
        if (stringAfterEscMarker.isFirstCharDigit()) {
            if (stringAfterEscMarker.isLastChar('\\')) {
                String charOctCode = stringAfterEscMarker.toStringExcludeLastChar();
                try {
                    return new UnescapeResult((char)Integer.parseInt(charOctCode, 8), false, false);
                }
                catch (NumberFormatException ex) {
                    return new UnescapeResult('/', false, true);
                }
            }
            return new UnescapeResult('/', true, false);
        }
        return new UnescapeResult(stringAfterEscMarker.charAt(0), false, true);
    }

    public static boolean isCharAllowedForUnquotedAtom(char chr) {
        return Character.isLetterOrDigit(chr) || chr == '_';
    }

    public static boolean isCharNotAppropriateForHexNum(char chr) {
        return !(chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F');
    }

    public static String escapeString(String str, Quotation quotingType) {
        StringBuilder result = new StringBuilder(str.length() << 1);
        int strLen = str.length();
        block13: for (int i = 0; i < strLen; ++i) {
            char chr = str.charAt(i);
            switch (chr) {
                case '\u0007': {
                    result.append("\\a");
                    continue block13;
                }
                case '\b': {
                    result.append("\\b");
                    continue block13;
                }
                case '\f': {
                    result.append("\\f");
                    continue block13;
                }
                case '\n': {
                    result.append("\\n");
                    continue block13;
                }
                case '\r': {
                    result.append("\\r");
                    continue block13;
                }
                case '`': {
                    if (quotingType == Quotation.BACK_TICK) {
                        result.append("\\`");
                        continue block13;
                    }
                    result.append('`');
                    continue block13;
                }
                case '\u001b': {
                    result.append("\\e");
                    continue block13;
                }
                case '\t': {
                    result.append("\\t");
                    continue block13;
                }
                case '\"': {
                    if (quotingType == Quotation.DOUBLE) {
                        result.append("\\\"");
                        continue block13;
                    }
                    result.append('\"');
                    continue block13;
                }
                case '\'': {
                    if (quotingType == Quotation.SINGLE) {
                        result.append("\\'");
                        continue block13;
                    }
                    result.append('\'');
                    continue block13;
                }
                case '\u000b': {
                    result.append("\\v");
                    continue block13;
                }
                default: {
                    if (Character.isISOControl(chr)) {
                        result.append('\\').append(Integer.toOctalString(chr)).append('\\');
                        continue block13;
                    }
                    result.append(chr);
                }
            }
        }
        return result.toString();
    }

    public static final class UnescapeResult {
        private final boolean needsMore;
        private final boolean error;
        private final char decoded;

        private UnescapeResult(char decoded, boolean needsMore, boolean error) {
            this.decoded = decoded;
            this.needsMore = needsMore;
            this.error = error;
        }

        public boolean doesNeedMore() {
            return this.needsMore;
        }

        public boolean isError() {
            return this.error;
        }

        public char getDecoded() {
            return this.decoded;
        }
    }
}

