/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.ant;

import com.igormaznitsa.jcp.JCPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class PreprocessTask
extends Task
implements PreprocessorLogger,
SpecialVariableProcessor {
    private File sourceDirectory = null;
    private File destinationDirectory = null;
    private String inCharSet = null;
    private String outCharSet = null;
    private String excludedExtensions = null;
    private String processing = null;
    private boolean disableOut = false;
    private boolean verbose = false;
    private boolean clearDstFlag = false;
    private boolean removeComments = false;
    private boolean keepLines = false;
    private boolean careForLastNextLine = false;
    private boolean compareDestination = false;
    private Map<String, Value> antVariables;
    private final List<Global> globalVariables = new ArrayList<Global>();
    private final List<CfgFile> configFiles = new ArrayList<CfgFile>();

    public void setCompareDestiation(boolean flag) {
        this.compareDestination = flag;
    }

    public void setSource(File src) {
        this.sourceDirectory = src;
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public void setDestination(File dst) {
        this.destinationDirectory = dst;
    }

    public void setInCharset(String charSet) {
        this.inCharSet = charSet;
    }

    public void setOutCharset(String charSet) {
        this.outCharSet = charSet;
    }

    public void setExcluded(String ext) {
        this.excludedExtensions = ext;
    }

    public void setProcessing(String ext) {
        this.processing = ext;
    }

    public void setClear(boolean flag) {
        this.clearDstFlag = flag;
    }

    public void setRemoveComments(boolean flag) {
        this.removeComments = flag;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setKeepLines(boolean flag) {
        this.keepLines = flag;
    }

    public void setDisableOut(boolean flag) {
        this.disableOut = flag;
    }

    public Global createGlobal() {
        Global result = new Global();
        this.globalVariables.add(result);
        return result;
    }

    public CfgFile createCfgFile() {
        CfgFile result = new CfgFile();
        this.configFiles.add(result);
        return result;
    }

    private void fillCfgFiles(PreprocessorContext context) {
        for (CfgFile f : this.configFiles) {
            if (f.getFile() != null) {
                context.addConfigFile(f.getFile());
                continue;
            }
            throw context.makeException("A Config file record doesn't contain the 'file' attribute", null);
        }
    }

    private void fillGlobalVars(PreprocessorContext context) {
        for (Global g : this.globalVariables) {
            if (g.getName() != null && g.getValue() != null) {
                context.setGlobalVariable(g.getName(), Value.recognizeRawString(g.getValue()));
                continue;
            }
            throw context.makeException("Wrong global definition, may be there is neither 'name' nor 'value' attribute", null);
        }
    }

    PreprocessorContext generatePreprocessorContext() {
        this.fillAntVariables();
        PreprocessorContext context = new PreprocessorContext();
        context.setPreprocessorLogger(this);
        context.registerSpecialVariableProcessor(this);
        if (this.destinationDirectory != null) {
            context.setDestinationDirectory(this.destinationDirectory.getAbsolutePath());
        }
        if (this.sourceDirectory != null) {
            context.setSourceDirectories(this.sourceDirectory.getAbsolutePath());
        } else {
            context.setSourceDirectories(this.getProject().getBaseDir().getAbsolutePath());
        }
        if (this.excludedExtensions != null) {
            context.setExcludedFileExtensions(this.excludedExtensions);
        }
        if (this.processing != null) {
            context.setProcessingFileExtensions(this.processing);
        }
        if (this.inCharSet != null) {
            context.setInCharacterEncoding(this.inCharSet);
        }
        if (this.outCharSet != null) {
            context.setOutCharacterEncoding(this.outCharSet);
        }
        context.setCompareDestination(this.compareDestination);
        context.setClearDestinationDirBefore(this.clearDstFlag);
        context.setFileOutputDisabled(this.disableOut);
        context.setRemoveComments(this.removeComments);
        context.setVerbose(this.verbose);
        context.setKeepLines(this.keepLines);
        context.setCareForLastNextLine(this.careForLastNextLine);
        this.fillCfgFiles(context);
        this.fillGlobalVars(context);
        return context;
    }

    public void execute() throws BuildException {
        PreprocessorContext context = null;
        try {
            context = this.generatePreprocessorContext();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
        JCPreprocessor preprocessor = new JCPreprocessor(context);
        try {
            preprocessor.execute();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
    }

    @Override
    public void error(String message) {
        this.log(message, 0);
    }

    @Override
    public void info(String message) {
        this.log(message, 2);
    }

    @Override
    public void debug(String message) {
        this.log(message, 4);
    }

    @Override
    public void warning(String message) {
        this.log(message, 1);
    }

    private void fillAntVariables() {
        Map<String, Value> result;
        Project theProject = this.getProject();
        if (theProject == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (Object key : this.getProject().getProperties().keySet()) {
                String keyStr = key.toString();
                String value = theProject.getProperty(keyStr);
                if (value == null) continue;
                result.put("ant." + keyStr.toLowerCase(Locale.ENGLISH), Value.valueOf(value));
            }
        }
        this.antVariables = result;
    }

    @Override
    public String[] getVariableNames() {
        String[] result = this.antVariables == null ? new String[]{} : this.antVariables.keySet().toArray(new String[this.antVariables.size()]);
        return result;
    }

    @Override
    public Value getVariable(String varName, PreprocessorContext context) {
        if (this.antVariables == null) {
            throw context.makeException("Non-initialized ANT property map detected", null);
        }
        Value result = this.antVariables.get(varName);
        if (result == null) {
            throw context.makeException("Request for unsupported Ant property '" + varName + '\'', null);
        }
        return result;
    }

    @Override
    public void setVariable(String varName, Value value, PreprocessorContext context) {
        throw context.makeException("Request to change ANT property '" + varName + "'. NB! ANT properties are read only!", null);
    }

    public static class Global {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class CfgFile {
        private File file;

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

