/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;

public class GlobalVariableDefiningFileHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "@";

    @Override
    public String getDescription() {
        return "load global variable list from file defined by either path or expression (last one needs @@)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean processCommandLineKey(String key, PreprocessorContext context) {
        boolean result = false;
        if (key == null) return result;
        if (key.isEmpty()) return result;
        if (key.charAt(0) != '@') return result;
        String stringRest = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key);
        if (stringRest.isEmpty()) {
            throw context.makeException("Empty string", null);
        }
        File file = null;
        if (stringRest.charAt(0) == '@') {
            Value resultValue;
            stringRest = PreprocessorUtils.extractTrimmedTail(ARG_NAME, stringRest);
            if (context.isVerbose()) {
                context.logForVerbose("Global parameter file defined through expression '" + stringRest + '\'');
            }
            if ((resultValue = Expression.evalExpression(stringRest, context)) == null) throw context.makeException("Can't recognize expression to get global definition file [" + stringRest + ']', null);
            String fileName = resultValue.toString();
            file = new File(fileName);
        } else {
            file = new File(stringRest);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Reading global definition file [" + PreprocessorUtils.getFilePath(file) + "]  '" + stringRest + '\'');
        }
        if (!file.isFile()) throw context.makeException("Can't find the global definition file '" + PreprocessorUtils.getFilePath(file) + '\'', null);
        context.addConfigFile(file);
        return true;
    }

    @Override
    public String getKeyName() {
        return ARG_NAME;
    }
}

