/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.containers;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class FileInfoContainer {
    private final File sourceFile;
    private final boolean forCopyOnly;
    private boolean excludedFromPreprocessing;
    private String destFolder;
    private String destFileName;

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean isExcludedFromPreprocessing() {
        return this.excludedFromPreprocessing;
    }

    public boolean isForCopyOnly() {
        return this.forCopyOnly;
    }

    public String getDestinationDir() {
        return this.destFolder;
    }

    public String getDestinationName() {
        return this.destFileName;
    }

    public FileInfoContainer(File srcFile, String dstFileName, boolean copyOnly) {
        PreprocessorUtils.assertNotNull("The source file is null", srcFile);
        PreprocessorUtils.assertNotNull("The destination file name is null", dstFileName);
        this.forCopyOnly = copyOnly;
        this.excludedFromPreprocessing = false;
        this.sourceFile = srcFile;
        int lastDirSeparator = dstFileName.lastIndexOf(47);
        if (lastDirSeparator < 0) {
            lastDirSeparator = dstFileName.lastIndexOf(92);
        }
        if (lastDirSeparator < 0) {
            this.destFolder = "." + File.separatorChar;
            this.destFileName = dstFileName;
        } else {
            this.destFolder = dstFileName.substring(0, lastDirSeparator);
            this.destFileName = dstFileName.substring(lastDirSeparator + 1);
        }
    }

    public String getDestinationFilePath() {
        String dir = this.destFolder;
        if (!dir.isEmpty() && dir.charAt(dir.length() - 1) != File.separatorChar) {
            dir = dir + File.separatorChar;
        }
        return dir + this.destFileName;
    }

    public String toString() {
        return "FileInfoContainer: source=" + PreprocessorUtils.getFilePath(this.sourceFile) + " destFolder=" + this.destFolder + " destFile=" + this.destFileName;
    }

    public List<PreprocessingState.ExcludeIfInfo> processGlobalDirectives(PreprocessingState state, PreprocessorContext context) throws IOException {
        PreprocessingState preprocessingState;
        block11: {
            preprocessingState = state == null ? context.produceNewPreprocessingState(this, 0) : state;
            String leftTrimmedString = null;
            try {
                block5: while (true) {
                    String nonTrimmedProcessingString = preprocessingState.nextLine();
                    Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                    if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                            processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                        }
                        nonTrimmedProcessingString = null;
                    }
                    if (nonTrimmedProcessingString == null) {
                        preprocessingState.popTextContainer();
                        if (!preprocessingState.isIncludeStackEmpty()) continue;
                        break block11;
                    }
                    leftTrimmedString = PreprocessorUtils.leftTrim(nonTrimmedProcessingString);
                    if (!leftTrimmedString.startsWith("//#")) continue;
                    switch (this.processDirective(preprocessingState, PreprocessorUtils.extractTail("//#", leftTrimmedString), context, true)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: 
                        case SHOULD_BE_COMMENTED: {
                            continue block5;
                        }
                    }
                    break;
                }
                throw new Error("Unsupported result");
            }
            catch (Exception unexpected) {
                PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
                if (pp == null) {
                    throw preprocessingState.makeException("Unexpected exception detected", leftTrimmedString, unexpected);
                }
                throw pp;
            }
        }
        if (!preprocessingState.isIfStackEmpty()) {
            TextFileDataContainer lastIf = preprocessingState.peekIf();
            throw new PreprocessorException("Unclosed //#_if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
        }
        return preprocessingState.popAllExcludeIfInfoData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreprocessingState preprocessFile(PreprocessingState state, PreprocessorContext context) throws IOException {
        if (!context.isCloned()) {
            context.clearLocalVariables();
        }
        PreprocessingState preprocessingState = state != null ? state : context.produceNewPreprocessingState(this, 1);
        String leftTrimmedString = null;
        TextFileDataContainer lastTextFileDataContainer = null;
        try {
            block6: while (true) {
                String text;
                boolean usePrintLn;
                int numberOfSpacesAtTheLineBeginning;
                String rawString = preprocessingState.nextLine();
                boolean presentedNextLine = preprocessingState.hasReadLineNextLineInEnd();
                Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                    if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                    }
                    rawString = null;
                }
                if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.END_PROCESSING)) {
                    preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.END_PROCESSING);
                    rawString = null;
                }
                if (rawString == null) {
                    lastTextFileDataContainer = preprocessingState.popTextContainer();
                    if (!preprocessingState.isIncludeStackEmpty()) continue;
                    break;
                }
                leftTrimmedString = PreprocessorUtils.leftTrim(rawString);
                String stringPrefix = leftTrimmedString.isEmpty() ? rawString : ((numberOfSpacesAtTheLineBeginning = rawString.indexOf(leftTrimmedString)) > 0 ? rawString.substring(0, numberOfSpacesAtTheLineBeginning) : "");
                String stringToBeProcessed = leftTrimmedString;
                boolean bl = usePrintLn = presentedNextLine || !context.isCareForLastNextLine();
                if (stringToBeProcessed.startsWith("//#")) {
                    String extractedDirective = PreprocessorUtils.extractTail("//#", stringToBeProcessed);
                    switch (this.processDirective(preprocessingState, extractedDirective, context, false)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: {
                            if (!context.isKeepLines()) continue block6;
                            text = stringPrefix + "//JCP! " + extractedDirective;
                            if (usePrintLn) {
                                preprocessingState.getPrinter().println(text);
                                continue block6;
                            }
                            preprocessingState.getPrinter().print(text);
                            continue block6;
                        }
                        case SHOULD_BE_COMMENTED: {
                            text = stringPrefix + "//JCP! " + extractedDirective;
                            if (usePrintLn) {
                                preprocessingState.getPrinter().println(text);
                                continue block6;
                            }
                            preprocessingState.getPrinter().print(text);
                            continue block6;
                        }
                    }
                    throw new Error("Unsupported result");
                }
                if (preprocessingState.isDirectiveCanBeProcessed() && !preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.TEXT_OUTPUT_DISABLED)) {
                    boolean startsWithTwoDollars = leftTrimmedString.startsWith("//$$");
                    if (!startsWithTwoDollars) {
                        stringToBeProcessed = PreprocessorUtils.processMacroses(leftTrimmedString, context);
                    }
                    if (startsWithTwoDollars) {
                        preprocessingState.getPrinter().print(stringPrefix);
                        text = PreprocessorUtils.extractTail("//$$", leftTrimmedString);
                        if (usePrintLn) {
                            preprocessingState.getPrinter().println(text);
                            continue;
                        }
                        preprocessingState.getPrinter().print(text);
                        continue;
                    }
                    if (stringToBeProcessed.startsWith("//$")) {
                        preprocessingState.getPrinter().print(stringPrefix);
                        text = PreprocessorUtils.extractTail("//$", stringToBeProcessed);
                        if (usePrintLn) {
                            preprocessingState.getPrinter().println(text);
                            continue;
                        }
                        preprocessingState.getPrinter().print(text);
                        continue;
                    }
                    String strToOut = FileInfoContainer.processStringForTailRemover(stringToBeProcessed);
                    if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.COMMENT_NEXT_LINE)) {
                        preprocessingState.getPrinter().print("//");
                        preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.COMMENT_NEXT_LINE);
                    }
                    preprocessingState.getPrinter().print(stringPrefix);
                    if (usePrintLn) {
                        preprocessingState.getPrinter().println(strToOut);
                        continue;
                    }
                    preprocessingState.getPrinter().print(strToOut);
                    continue;
                }
                if (!context.isKeepLines()) continue;
                String text2 = "//JCP> " + rawString;
                if (usePrintLn) {
                    preprocessingState.getPrinter().println(text2);
                    continue;
                }
                preprocessingState.getPrinter().print(text2);
            }
        }
        catch (Exception unexpected) {
            String message = unexpected.getMessage() == null ? "Unexpected exception" : unexpected.getMessage();
            throw preprocessingState.makeException(message, leftTrimmedString, unexpected);
        }
        if (!preprocessingState.isIfStackEmpty()) {
            TextFileDataContainer lastIf = preprocessingState.peekIf();
            throw new PreprocessorException("Unclosed //#if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
        }
        if (!preprocessingState.isWhileStackEmpty()) {
            TextFileDataContainer lastWhile = preprocessingState.peekWhile();
            throw new PreprocessorException("Unclosed //#while instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastWhile.getFile(), lastWhile.getNextStringIndex())}, null);
        }
        if (!context.isFileOutputDisabled() && lastTextFileDataContainer != null && lastTextFileDataContainer.isAutoFlush()) {
            File outFile = context.createDestinationFileForPath(this.getDestinationFilePath());
            boolean wasSaved = preprocessingState.saveBuffersToFile(outFile, context.isRemoveComments());
            if (context.isVerbose()) {
                context.logForVerbose("Content was " + (wasSaved ? "saved" : "not saved") + " into file '" + outFile + "'");
            }
        }
        return preprocessingState;
    }

    private static String processStringForTailRemover(String str) {
        int tailRemoverStart = str.indexOf("/*-*/");
        if (tailRemoverStart >= 0) {
            return str.substring(0, tailRemoverStart);
        }
        return str;
    }

    private boolean checkDirectiveArgumentRoughly(AbstractDirectiveHandler directive, String rest) {
        boolean result;
        DirectiveArgumentType argument = directive.getArgumentType();
        String trimmedRest = rest.trim();
        switch (argument) {
            case NONE: {
                result = trimmedRest.isEmpty();
                break;
            }
            case ONOFF: {
                if (trimmedRest.isEmpty()) {
                    result = false;
                    break;
                }
                char firstChar = rest.charAt(0);
                boolean bl = result = firstChar == '+' || firstChar == '-';
                if (rest.length() <= 1) break;
                result = result && Character.isSpaceChar(rest.charAt(1));
                break;
            }
            case TAIL: {
                result = true;
                break;
            }
            default: {
                result = !trimmedRest.isEmpty() && Character.isSpaceChar(rest.charAt(0));
            }
        }
        return result;
    }

    protected AfterDirectiveProcessingBehaviour processDirective(PreprocessingState state, String directiveString, PreprocessorContext context, boolean firstPass) throws IOException {
        boolean executionEnabled = state.isDirectiveCanBeProcessed();
        for (AbstractDirectiveHandler handler : AbstractDirectiveHandler.DIRECTIVES) {
            String name = handler.getName();
            if (!directiveString.startsWith(name)) continue;
            if (firstPass && !handler.isGlobalPhaseAllowed() || !firstPass && !handler.isPreprocessingPhaseAllowed()) {
                return AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
            }
            boolean allowedForExecution = executionEnabled || !handler.executeOnlyWhenExecutionAllowed();
            String restOfString = PreprocessorUtils.extractTail(name, directiveString);
            if (this.checkDirectiveArgumentRoughly(handler, restOfString)) {
                if (allowedForExecution) {
                    return handler.execute(restOfString, context);
                }
                return context.isKeepLines() ? AfterDirectiveProcessingBehaviour.SHOULD_BE_COMMENTED : AfterDirectiveProcessingBehaviour.PROCESSED;
            }
            throw context.makeException("Detected bad argument for //#" + handler.getName(), null);
        }
        throw context.makeException("Unknown preprocessor directive [" + directiveString + ']', null);
    }

    public void setDestinationDir(String destDir) {
        PreprocessorUtils.assertNotNull("String is null", destDir);
        this.destFolder = destDir;
    }

    public void setDestinationName(String destName) {
        PreprocessorUtils.assertNotNull("String is null", destName);
        this.destFileName = destName;
    }

    public void setExcluded(boolean flag) {
        this.excludedFromPreprocessing = flag;
    }
}

