/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.EnvironmentVariableProcessor;
import com.igormaznitsa.jcp.context.JCPSpecialVariableProcessor;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.logger.SystemOutLogger;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PreprocessorContext {
    public static final String DEFAULT_SOURCE_DIRECTORY = "." + File.separatorChar;
    public static final String DEFAULT_DEST_DIRECTORY = ".." + File.separatorChar + "preprocessed";
    public static final String DEFAULT_PROCESSING_EXTENSIONS = "java,txt,htm,html";
    public static final String DEFAULT_EXCLUDED_EXTENSIONS = "xml";
    public static final String DEFAULT_CHARSET = "UTF8";
    private boolean verbose = false;
    private boolean removeComments = false;
    private boolean clearDestinationDirectoryBefore = false;
    private boolean fileOutputDisabled = false;
    private boolean keepNonExecutingLines = false;
    private boolean careForLastNextLine = false;
    private boolean compareDestination = false;
    private String sourceDirectories;
    private String destinationDirectory;
    private File destinationDirectoryFile;
    private File[] sourceDirectoryFiles;
    private Set<String> processingFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitForChar("java,txt,htm,html", ',')));
    private Set<String> excludedFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitForChar("xml", ',')));
    private PreprocessorExtension preprocessorExtension;
    private String inCharacterEncoding = "UTF8";
    private String outCharacterEncoding = "UTF8";
    private final Map<String, Value> globalVarTable = new HashMap<String, Value>();
    private final Map<String, Value> localVarTable = new HashMap<String, Value>();
    private final Map<String, SpecialVariableProcessor> mapVariableNameToSpecialVarProcessor = new HashMap<String, SpecialVariableProcessor>();
    private final Map<String, Object> sharedResources = new HashMap<String, Object>();
    private PreprocessorLogger preprocessorLogger = new SystemOutLogger();
    private final List<File> configFiles = new ArrayList<File>();
    private transient PreprocessingState currentState;
    private final boolean cloned;
    private final TextFileDataContainer currentInCloneSource;

    public PreprocessorContext() {
        this.setSourceDirectories(DEFAULT_SOURCE_DIRECTORY).setDestinationDirectory(DEFAULT_DEST_DIRECTORY);
        this.registerSpecialVariableProcessor(new JCPSpecialVariableProcessor());
        this.registerSpecialVariableProcessor(new EnvironmentVariableProcessor());
        this.cloned = false;
        this.currentInCloneSource = null;
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public boolean isCareForLastNextLine() {
        return this.careForLastNextLine;
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public PreprocessorContext(PreprocessorContext context) {
        PreprocessorUtils.assertNotNull("Source context must not be null", context);
        this.verbose = context.verbose;
        this.removeComments = context.removeComments;
        this.clearDestinationDirectoryBefore = context.clearDestinationDirectoryBefore;
        this.fileOutputDisabled = context.fileOutputDisabled;
        this.keepNonExecutingLines = context.keepNonExecutingLines;
        this.sourceDirectories = context.sourceDirectories;
        this.destinationDirectory = context.destinationDirectory;
        this.destinationDirectoryFile = context.destinationDirectoryFile;
        this.sourceDirectoryFiles = (File[])context.sourceDirectoryFiles.clone();
        this.careForLastNextLine = context.careForLastNextLine;
        this.processingFileExtensions.clear();
        this.processingFileExtensions.addAll(context.processingFileExtensions);
        this.excludedFileExtensions.clear();
        this.excludedFileExtensions.addAll(context.excludedFileExtensions);
        this.preprocessorExtension = context.preprocessorExtension;
        this.inCharacterEncoding = context.inCharacterEncoding;
        this.outCharacterEncoding = context.outCharacterEncoding;
        this.compareDestination = context.compareDestination;
        this.globalVarTable.putAll(context.globalVarTable);
        this.localVarTable.putAll(context.localVarTable);
        this.mapVariableNameToSpecialVarProcessor.putAll(context.mapVariableNameToSpecialVarProcessor);
        this.sharedResources.putAll(context.sharedResources);
        this.configFiles.addAll(context.configFiles);
        this.currentState = context.currentState;
        this.cloned = true;
        this.currentInCloneSource = context.getPreprocessingState() == null ? null : context.getPreprocessingState().peekFile();
    }

    public void setPreprocessorLogger(PreprocessorLogger logger) {
        this.preprocessorLogger = logger;
    }

    public void registerSpecialVariableProcessor(SpecialVariableProcessor processor) {
        PreprocessorUtils.assertNotNull("Processor is null", processor);
        for (String varName : processor.getVariableNames()) {
            PreprocessorUtils.assertNotNull("A Special Var name is null", varName);
            if (this.mapVariableNameToSpecialVarProcessor.containsKey(varName)) {
                throw new IllegalStateException("There is already defined processor for " + varName);
            }
            this.mapVariableNameToSpecialVarProcessor.put(varName, processor);
        }
    }

    public void logInfo(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.info(text);
        }
    }

    public void logError(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.error(text);
        }
    }

    public void logDebug(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.debug(text);
        }
    }

    public void logWarning(String text) {
        if (text != null || this.preprocessorLogger != null) {
            this.preprocessorLogger.warning(text);
        }
    }

    public PreprocessorContext setRemoveComments(boolean removingComments) {
        this.removeComments = removingComments;
        return this;
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setFileOutputDisabled(boolean flag) {
        this.fileOutputDisabled = flag;
    }

    public boolean isFileOutputDisabled() {
        return this.fileOutputDisabled;
    }

    public PreprocessorContext setSourceDirectories(String directories) {
        PreprocessorUtils.assertNotNull("Source directory is null", directories);
        this.sourceDirectories = directories;
        this.sourceDirectoryFiles = this.getParsedSourceDirectoryAsFiles();
        return this;
    }

    public void setSharedResource(String name, Object obj) {
        PreprocessorUtils.assertNotNull("Name is null", name);
        PreprocessorUtils.assertNotNull("Object is null", obj);
        this.sharedResources.put(name, obj);
    }

    public Object getSharedResource(String name) {
        PreprocessorUtils.assertNotNull("Name is null", name);
        return this.sharedResources.get(name);
    }

    public Object removeSharedResource(String name) {
        PreprocessorUtils.assertNotNull("Name is null", name);
        return this.sharedResources.remove(name);
    }

    public String getSourceDirectories() {
        return this.sourceDirectories;
    }

    public File[] getSourceDirectoryAsFiles() {
        return this.sourceDirectoryFiles;
    }

    private File[] getParsedSourceDirectoryAsFiles() {
        String[] splitted = PreprocessorUtils.splitForChar(this.sourceDirectories, ';');
        File[] result = new File[splitted.length];
        int index = 0;
        for (String dirName : splitted) {
            File dir = new File(dirName);
            if (!dir.isDirectory()) {
                throw new IllegalStateException("Can't find a source directory [" + PreprocessorUtils.getFilePath(dir) + ']');
            }
            result[index++] = dir;
        }
        return result;
    }

    public PreprocessorContext setDestinationDirectory(String directory) {
        PreprocessorUtils.assertNotNull("Directory is null", directory);
        this.destinationDirectory = directory;
        this.destinationDirectoryFile = new File(this.destinationDirectory);
        return this;
    }

    public File getDestinationDirectoryAsFile() {
        return this.destinationDirectoryFile;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public PreprocessorContext setProcessingFileExtensions(String extensions) {
        PreprocessorUtils.assertNotNull("Argument is null", extensions);
        this.processingFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitExtensionCommaList(extensions)));
        return this;
    }

    public String[] getProcessingFileExtensions() {
        return this.processingFileExtensions.toArray(new String[this.processingFileExtensions.size()]);
    }

    public final boolean isFileAllowedToBeProcessed(File file) {
        if (file == null || !file.exists() || file.isDirectory() || file.length() == 0L) {
            return false;
        }
        return this.processingFileExtensions.contains(PreprocessorUtils.getFileExtension(file));
    }

    public final boolean isFileExcludedFromProcess(File file) {
        boolean result = file != null && file.isFile() ? this.excludedFileExtensions.contains(PreprocessorUtils.getFileExtension(file)) : false;
        return result;
    }

    public PreprocessorContext setExcludedFileExtensions(String extensions) {
        PreprocessorUtils.assertNotNull("Argument is null", extensions);
        this.excludedFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitExtensionCommaList(extensions)));
        return this;
    }

    public String[] getExcludedFileExtensions() {
        return this.excludedFileExtensions.toArray(new String[this.excludedFileExtensions.size()]);
    }

    public PreprocessorContext setClearDestinationDirBefore(boolean flag) {
        this.clearDestinationDirectoryBefore = flag;
        return this;
    }

    public boolean doesClearDestinationDirBefore() {
        return this.clearDestinationDirectoryBefore;
    }

    public PreprocessorContext setLocalVariable(String name, Value value) {
        PreprocessorUtils.assertNotNull("Variable name is null", name);
        PreprocessorUtils.assertNotNull("Value is null", value);
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            throw this.makeException("Not defined variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to set either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        this.localVarTable.put(normalized, value);
        return this;
    }

    public PreprocessorContext removeLocalVariable(String name) {
        PreprocessorUtils.assertNotNull("Variable name is null", name);
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to remove either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing local variable '" + normalized + "'");
        }
        this.localVarTable.remove(normalized);
        return this;
    }

    public PreprocessorContext removeGlobalVariable(String name) {
        PreprocessorUtils.assertNotNull("Variable name is null", name);
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized)) {
            throw this.makeException("Attempting to remove a special variable as a global one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing global variable '" + normalized + "'");
        }
        this.globalVarTable.remove(normalized);
        return this;
    }

    public Value getLocalVariable(String name) {
        if (name == null) {
            return null;
        }
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            return null;
        }
        return this.localVarTable.get(normalized);
    }

    public boolean containsLocalVariable(String name) {
        if (name == null) {
            return false;
        }
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            return false;
        }
        return this.localVarTable.containsKey(normalized);
    }

    public PreprocessorContext clearLocalVariables() {
        this.localVarTable.clear();
        return this;
    }

    public PreprocessorContext setGlobalVariable(String name, Value value) {
        PreprocessorUtils.assertNotNull("Variable name is null", name);
        String normalizedName = PreprocessorUtils.normalizeVariableName(name);
        if (normalizedName.isEmpty()) {
            throw this.makeException("Name is empty", null);
        }
        PreprocessorUtils.assertNotNull("Value is null", value);
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalizedName)) {
            this.mapVariableNameToSpecialVarProcessor.get(normalizedName).setVariable(normalizedName, value, this);
        } else {
            if (this.isVerbose()) {
                String valueAsStr = value.toString();
                if (this.globalVarTable.containsKey(normalizedName)) {
                    this.logForVerbose("Replacing global variable [" + normalizedName + '=' + valueAsStr + ']');
                } else {
                    this.logForVerbose("Defining new global variable [" + normalizedName + '=' + valueAsStr + ']');
                }
            }
            this.globalVarTable.put(normalizedName, value);
        }
        return this;
    }

    public boolean containsGlobalVariable(String name) {
        if (name == null) {
            return false;
        }
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            return false;
        }
        return this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized);
    }

    public Value findVariableForName(String name) {
        if (name == null) {
            return null;
        }
        String normalized = PreprocessorUtils.normalizeVariableName(name);
        if (normalized.isEmpty()) {
            return null;
        }
        SpecialVariableProcessor processor = this.mapVariableNameToSpecialVarProcessor.get(normalized);
        if (processor != null && this.currentState != null) {
            return processor.getVariable(normalized, this);
        }
        Value val = this.getLocalVariable(normalized);
        if (val != null) {
            return val;
        }
        return this.globalVarTable.get(normalized);
    }

    public boolean isGlobalVariable(String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.globalVarTable.containsKey(normalized) || this.mapVariableNameToSpecialVarProcessor.containsKey(normalized);
        }
        return result;
    }

    public boolean isLocalVariable(String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.localVarTable.containsKey(normalized);
        }
        return result;
    }

    public PreprocessorContext setVerbose(boolean flag) {
        this.verbose = flag;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public PreprocessorContext setCompareDestination(boolean flag) {
        this.compareDestination = flag;
        return this;
    }

    public boolean isCompareDestination() {
        return this.compareDestination;
    }

    public PreprocessorContext setKeepLines(boolean flag) {
        this.keepNonExecutingLines = flag;
        return this;
    }

    public boolean isKeepLines() {
        return this.keepNonExecutingLines;
    }

    public PreprocessorContext setPreprocessorExtension(PreprocessorExtension extension) {
        this.preprocessorExtension = extension;
        return this;
    }

    public PreprocessorExtension getPreprocessorExtension() {
        return this.preprocessorExtension;
    }

    public PreprocessorContext setInCharacterEncoding(String characterEncoding) {
        PreprocessorUtils.assertNotNull("Value is null", characterEncoding);
        if (!Charset.isSupported(characterEncoding)) {
            throw this.makeException("Unsupported character encoding [" + characterEncoding + ']', null);
        }
        this.inCharacterEncoding = characterEncoding;
        return this;
    }

    public PreprocessorContext setOutCharacterEncoding(String characterEncoding) {
        if (!Charset.isSupported(characterEncoding)) {
            throw this.makeException("Unsupported character encoding [" + characterEncoding + ']', null);
        }
        this.outCharacterEncoding = characterEncoding;
        return this;
    }

    public String getInCharacterEncoding() {
        return this.inCharacterEncoding;
    }

    public String getOutCharacterEncoding() {
        return this.outCharacterEncoding;
    }

    public File createDestinationFileForPath(String path) {
        PreprocessorUtils.assertNotNull("Path is null", path);
        if (path.isEmpty()) {
            throw this.makeException("File name is empty", null);
        }
        return new File(this.getDestinationDirectoryAsFile(), path);
    }

    public File getSourceFile(String path) throws IOException {
        if (path == null) {
            throw this.makeException("Path is null", null);
        }
        if (path.isEmpty()) {
            throw this.makeException("Folder path is empty", null);
        }
        File result = null;
        String parentDir = null;
        if (this.currentState != null && this.currentState.peekFile() != null) {
            parentDir = this.currentState.peekFile().getFile().getParent();
        }
        if (FilenameUtils.getPrefixLength(path) <= 0 && parentDir != null) {
            result = new File(parentDir, path);
        } else {
            ArrayList<File> findFiles = new ArrayList<File>();
            for (File root : this.getSourceDirectoryAsFiles()) {
                File variant = new File(root, path);
                if (!variant.exists() || !variant.isFile()) continue;
                findFiles.add(variant);
            }
            if (findFiles.size() == 1) {
                result = (File)findFiles.get(0);
            } else if (findFiles.isEmpty()) {
                result = null;
            } else {
                throw this.makeException("Found several variants for path '" + path + "' in different source roots", null);
            }
        }
        if (result == null || !result.isFile()) {
            throw this.makeException("The File '" + PreprocessorUtils.getFilePath(result) + "' is not found or not a file", null);
        }
        return result;
    }

    public void addConfigFile(File file) {
        PreprocessorUtils.assertNotNull("File is null", file);
        this.configFiles.add(file);
    }

    public File[] getConfigFiles() {
        return this.configFiles.toArray(new File[this.configFiles.size()]);
    }

    public PreprocessingState produceNewPreprocessingState(FileInfoContainer fileContainer, int phaseIndex) throws IOException {
        PreprocessorUtils.assertNotNull("File container is null", fileContainer);
        if (this.verbose) {
            if (phaseIndex == 0) {
                this.logInfo("Start search global definitions in '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            } else {
                this.logInfo("Start preprocessing '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            }
        }
        this.currentState = new PreprocessingState(this, fileContainer, this.getInCharacterEncoding(), this.getOutCharacterEncoding(), this.compareDestination);
        return this.currentState;
    }

    public PreprocessingState produceNewPreprocessingState(FileInfoContainer fileContainer, TextFileDataContainer textContainer) {
        this.currentState = new PreprocessingState(this, fileContainer, textContainer, this.getInCharacterEncoding(), this.getOutCharacterEncoding(), this.compareDestination);
        return this.currentState;
    }

    public PreprocessingState getPreprocessingState() {
        return this.currentState;
    }

    public PreprocessorException makeException(String text, Throwable cause) {
        String sourceLine;
        FilePositionInfo[] includeStack;
        if (cause != null && cause instanceof PreprocessorException) {
            return (PreprocessorException)cause;
        }
        if (this.currentState == null) {
            includeStack = PreprocessingState.EMPTY_STACK;
            sourceLine = "";
        } else {
            includeStack = this.currentState.makeIncludeStack();
            sourceLine = this.currentState.getLastReadString();
        }
        return new PreprocessorException(text, sourceLine, includeStack, cause);
    }

    public void logForVerbose(String str) {
        if (this.isVerbose()) {
            String stack = this.currentState != null ? PreprocessorContext.makeStackView(this.currentInCloneSource, this.cloned, this.currentState.getCurrentIncludeStack()) : "";
            this.logInfo(str + (stack.isEmpty() ? (char)' ' : '\n') + stack);
        }
    }

    private static String makeStackView(TextFileDataContainer cloneSource, boolean cloned, List<TextFileDataContainer> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int tab = 5;
        for (int s = 0; s < tab; ++s) {
            builder.append(' ');
        }
        builder.append('{');
        if (cloned) {
            builder.append(cloneSource == null ? "*No src info" : "*" + cloneSource.getFile().getName() + ':' + cloneSource.getNextStringIndex());
        } else {
            builder.append("File chain");
        }
        builder.append('}');
        tab += 5;
        int fileIndex = 1;
        for (int i = list.size() - 1; i >= 0; --i) {
            TextFileDataContainer cur = list.get(i);
            builder.append('\n');
            for (int s = 0; s < tab; ++s) {
                builder.append(' ');
            }
            builder.append("\u2514>");
            builder.append(fileIndex++).append(". ");
            builder.append(cur.getFile().getName()).append(':').append(cur.getLastReadStringIndex() + 1);
            tab += 3;
        }
        return builder.toString();
    }
}

