/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class AbortDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "abort";
    }

    @Override
    public String getReference() {
        return "abort preprocessing and show the line tail as message (allows macroses)";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.TAIL;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String rawTail, PreprocessorContext context) {
        String normal = !rawTail.isEmpty() && Character.isSpaceChar(rawTail.charAt(0)) ? rawTail.substring(1) : rawTail;
        String message = "ABORT: " + PreprocessorUtils.processMacroses(normal, context);
        if (context.isVerbose()) {
            context.logForVerbose(message);
        } else {
            context.logInfo(message);
        }
        context.getPreprocessingState().getPreprocessingFlags().add(PreprocessingFlag.ABORT_PROCESSING);
        return AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
    }
}

