/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionParser;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.Value;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class ActionDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "action";
    }

    @Override
    public String getReference() {
        return "call preprocessor user extension, arguments are comma separated";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.MULTIEXPRESSION;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        if (context.getPreprocessorExtension() != null) {
            try {
                List<ExpressionTree> args = this.parseString(string, context);
                Value[] results = new Value[args.size()];
                int index = 0;
                for (ExpressionTree expr : args) {
                    Value val = Expression.evalTree(expr, context);
                    results[index++] = val;
                }
                if (!context.getPreprocessorExtension().processAction(context, results)) {
                    throw context.makeException("Extension can't process action ", null);
                }
            }
            catch (IOException ex) {
                throw context.makeException("Unexpected string detected [" + string + ']', ex);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    private List<ExpressionTree> parseString(String str, PreprocessorContext context) throws IOException {
        ExpressionItem delimiter;
        String sources;
        FilePositionInfo[] stack;
        ExpressionParser parser = ExpressionParser.getInstance();
        PushbackReader reader = new PushbackReader(new StringReader(str));
        ArrayList<ExpressionTree> result = new ArrayList<ExpressionTree>();
        PreprocessingState state = context.getPreprocessingState();
        if (state == null) {
            stack = null;
            sources = null;
        } else {
            stack = state.makeIncludeStack();
            sources = state.getLastReadString();
        }
        do {
            ExpressionTree tree;
            if ((delimiter = parser.readExpression(reader, tree = state == null ? new ExpressionTree() : new ExpressionTree(stack, sources), context, false, true)) != null && ExpressionParser.SpecialItem.COMMA != delimiter) {
                throw context.makeException("Wrong argument format detected", null);
            }
            if (tree.isEmpty()) {
                if (delimiter != null) {
                    throw context.makeException("Empty argument", null);
                }
                break;
            }
            result.add(tree);
        } while (delimiter != null);
        return result;
    }
}

